' AddToMesh(mesh:TMesh, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)
' ScanMeshColors(mesh:TMesh)
' BrightenMeshColors(mesh:TMesh,factor:Float=1.0)
' UpdateMeshColor(mesh:TMesh, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
' UpdateMeshAlpha(mesh:TMesh, a:Float = 1.0)



' ----------------------------------------------------------------------------
' Adds a mesh to another mesh
' ----------------------------------------------------------------------------
Function AddToMesh(mesh:TMesh, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)
	
	Local v:Int[3]
		
	Local surface:TSurface = GetSurface(mesh, 1)
	
	Local surf:TSurface = GetSurface(singlesurfaceentity, CountSurfaces(singlesurfaceentity))
	
	If CountVertices(surf) + CountVertices(surface) > 32768 Then surf = CreateSurface(singlesurfaceentity)
		
	For Local i1:Int = 0 To CountTriangles(surface) - 1
			
		For Local i2:Int = 0 To 2
					
			Local oldv:Int = TriangleVertex(surface, i1, i2)
			TFormPoint VertexX(surface, oldv), VertexY(surface, oldv), VertexZ(surface, oldv), mesh, singlesurfaceentity
			v[i2] = AddVertex(surf, TFormedX(), TFormedY(), TFormedZ(), VertexU(surface, oldv), VertexV(surface, oldv))
			
			VertexNormal surf, v[i2], VertexNX(surface, oldv), VertexNY(surface, oldv), VertexNZ(surface, oldv)
			
			VertexColor surf, v[i2], r, g, b, a
						
		Next
		
		AddTriangle(surf, v[0], v[1], v[2])
				
	Next
	
End Function

' ----------------------------------------------------------------------------
' Scans Mesh Colors (for BrightenMeshColors)
' ----------------------------------------------------------------------------

Global MeshColors:Int[65536]

Function ScanMeshColors(mesh:TMesh)
	
	For Local s:Int = 1 To CountSurfaces(mesh)

		Local surf:TSurface = GetSurface(mesh, s)
	
		For Local v:Int = 0 To CountVertices(surf) - 1

			MeshColors[v] = CombineRGBA(VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), VertexAlpha(surf, v))
		
		Next

	Next
	
End Function



' ----------------------------------------------------------------------------
' Brightens Mesh Colors
' ----------------------------------------------------------------------------
Function BrightenMeshColors(mesh:TMesh, factor:Float = 1.0)
	
	Local r:Float, g:Float, b:Float

	For Local s:Int = 1 To CountSurfaces(mesh)

		Local surf:TSurface = GetSurface(mesh, s)
	
		For Local v:Int = 0 To CountVertices(surf) - 1

			r = (GetR(MeshColors[v]) - 127.5) / 128.0
			g = (GetG(MeshColors[v]) - 127.5) / 128.0
			b = (GetB(MeshColors[v]) - 127.5) / 128.0

			r:*factor
			g:*factor
			b:*factor

			r = 255 - ((1.0 - r) * 127.5)
			g = 255 - ((1.0 - g) * 127.5)
			b = 255 - ((1.0 - b) * 127.5)

			VertexColor surf, v, r, g, b
		
		Next

	Next
	
End Function


' ----------------------------------------------------------------------------
' Update Mesh Colors (RGBA)
' ----------------------------------------------------------------------------
Function UpdateMeshColor(mesh:TMesh, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	For Local s:Int = 1 To CountSurfaces(mesh)

		Local surf:TSurface = GetSurface(mesh, s)
	
		For Local v:Int = 0 To CountVertices(surf) - 1

			VertexColor surf, v, r, g, b, a
		
		Next

	Next
	
End Function



' ----------------------------------------------------------------------------
' Update Mesh Alpha
' ----------------------------------------------------------------------------
Function UpdateMeshAlpha(mesh:TMesh, a:Float = 1.0)
	
	For Local s:Int = 1 To CountSurfaces(mesh)

		Local surf:TSurface = GetSurface(mesh, s)
	
		For Local v:Int = 0 To CountVertices(surf) - 1

			VertexColor surf, v, VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), a
		
		Next

	Next
	
End Function