' RoTex(texture:TTexture, angle:Float, Scale:Float = 1)
' CreateGrid:TPixmap(size:Int=512,R:Int = 255, G:Int = 255, B:Int = 255, Alpha:Int = 255)
' CreateFakeShaderTexture:TPixmap()
' CreateSunTexture:TPixmap()
' CreateBrightmap:TTexture(r:Int,g:Int,b:Int)
' CreateBaseTexture:TPixmap(size:Int=32,r:Int=255,g:Int=255,b:Int=255,a:Float=1.0)
' CreateRingTexture:TPixmap(p:TPlanet,size:Int=512,factor:Float=1.0,fader:Float=0.25)



' ------------------------------------------------------------------------------------------------
' Rotate and scale a texture using separate calculations
' ------------------------------------------------------------------------------------------------
Function RoTex(texture:TTexture, angle:Float, Scale:Float = 1)

	Local x:Float
	Local y:Float

	ScaleTexture texture, Scale, Scale
	
	RotateTexture texture, angle
	
	x = Cos(angle) / Scale / 2.0
	y = Sin(angle) / Scale / 2.0
	
	PositionTexture texture, (x - 0.5) - y, (y - 0.5) + x
	
End Function



' ------------------------------------------------------------------------------------------------
' Create a Grid Texture
' ------------------------------------------------------------------------------------------------
Function CreateGrid:TPixmap(Size:Int = 512, R:Int = 255, G:Int = 255, B:Int = 255, Alpha:Int = 255)

	Local pixmap:TPixmap = CreatePixmap(Size, Size, PF_RGBA8888)

	For Local x:Int = 0 To Size - 1
		
		For Local y:Int = 0 To Size - 1
		
			WritePixel(pixmap, x, y, CombineRGBA(R, G, B, Alpha / 50))
		
			If x = 0 Or x = Size - 1 Then WritePixel(pixmap, x, y, CombineRGBA(R, G, B, Alpha))
			If y = 0 Or y = Size - 1 Then WritePixel(pixmap, x, y, CombineRGBA(R, G, B, Alpha))
		
		Next
	
	Next
	
	Return pixmap

End Function



' ------------------------------------------------------------------------------------------------
' Create a Fake Planet Shader Pixmap (pixmap must be loaded with flag 64!)
' ------------------------------------------------------------------------------------------------
Function CreateFakeShaderTexture:TPixmap()
	
	Local pixmap:TPixmap = CreatePixmap(512, 512, PF_RGBA8888)
	
	Local x:Int, y:Int, i:Float, j:Int, col:Int, rgb:Int
		
	For x = 0 To 511
		
		For y = 0 To 511
			
			rgb = 255 * $1000000 + 255 * $10000 + 255 * $100 + 255
			WritePixel(pixmap, x, y, rgb)
			
		Next
		
	Next
	
	For j = 0 To 255
		
		col = j * 1.0 / Exp((255 - j) * 0.001)
		
		If col > 255 Then col = 255
		If col < 0 Then col = 0
		
		rgb = col * $1000000 + col * $10000 + col * $100 + col
		
		For i = 0 To 360 Step 0.1
			
			WritePixel(pixmap, 255 + (Sin(i) * j), 255 + (Cos(i) * j), rgb)
			
		Next
		
	Next

	Return pixmap
	
End Function



' ------------------------------------------------------------------------------------------------
' Creates a Sun Texture
' ------------------------------------------------------------------------------------------------
Function CreateSunTexture:TPixmap()
	
	Local pixmap:TPixmap = CreatePixmap(512, 512, PF_RGBA8888)
	
	Local i:Float, j:Int, col:Int, rgb:Int
	
	For j = 0 To 255
		
		col = 255 - j
		If col > 255 Then col = 255
		rgb = col * $1000000 + col * $10000 + col * $100 + col
		
		For i = 0 To 360 Step 0.1
			
			WritePixel(pixmap, 256 + (Sin(i) * j), 256 + (Cos(i) * j), rgb)
			
		Next
		
	Next
	
	Return pixmap
	
End Function



' ----------------------------------------------------------------------------
' create a micro texture for brightness change
' ----------------------------------------------------------------------------
Function CreateBrightmap:TPixmap(r:Int, g:Int, b:Int)

	Local pixmap:TPixmap = CreatePixmap(2, 2, PF_RGB888)
	Local RGB:Int = CombineRGB(r, g, b)

	WritePixel(pixmap, 0, 0, RGB)
	WritePixel(pixmap, 0, 1, RGB)
	WritePixel(pixmap, 1, 0, RGB)
	WritePixel(pixmap, 1, 1, RGB)

	Return pixmap
	
End Function



' ----------------------------------------------------------------------------
' create a unicolor base texture for coloring a mesh
' ----------------------------------------------------------------------------
Function CreateBaseTexture:TPixmap(Size:Int = 32, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	Local x:Int, y:Int
	Local pixmap:TPixmap = CreatePixmap(Size, Size, PF_RGBA8888)
	
	For x = 0 To Size - 1

		For y = 0 To Size - 1

			WritePixel(pixmap, x, y, CombineRGBA(r, g, b, a * 255))

		Next

	Next
	
	Return pixmap
		
End Function

