' HomeKeeping(target:TEntity, world:TEntity, homesize:Int = 1000)



' ------------------------------------------------------------------------------------------------
' Homekeeping keeps the player in a given sandbox distance while the world moves around it
' ------------------------------------------------------------------------------------------------

Global globalx:Float, globaly:Float, globalz:Float
Global simx:Float, simy:Float, simz:Float

Function HomeKeeping(target:TEntity, world:TEntity, homesize:Int = 1000)

	' store Local player Position
	Local localx:Float = EntityX(target, 1)
	Local localy:Float = EntityY(target, 1)
	Local localz:Float = EntityZ(target, 1)

	' Check X axis
	While localx > homesize
	
		globalx:+homesize
		localx:-homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, -homesize, 0, 0
		
	Wend
	
	While localx < - homesize
	
		globalx:-homesize
		localx:+homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, homesize, 0, 0
		
	Wend

	' Check Y axis
	While localy > homesize
	
		globaly:+homesize
		localy:-homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, 0, -homesize, 0
		
	Wend
	
	While localy < - homesize
	
		globaly:-homesize
		localy:+homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, 0, homesize, 0
		
	Wend

	' Check Z axis
	While localz > homesize
	
		globalz:+homesize
		localz:-homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, 0, 0, -homesize
		
	Wend
	
	While localz < - homesize
	
		globalz:-homesize
		localz:+homesize
		PositionEntity target, localx, localy, localz
		MoveEntity world, 0, 0, homesize
		
	Wend

	' store simulated player Position
	simx = localx + globalx
	simy = localy + globaly
	simz = localz + globalz

End Function