' ------------------------------------------------------------------------------------------------
' Initialize Game
' ------------------------------------------------------------------------------------------------
Function InitGame()

	' --------------------------------------------------------------------------------------------
	' Start logfile
	' --------------------------------------------------------------------------------------------
	LogInit()	
	TIME.TotalStart(LOCALE.Get("LOG_INITIALIZESTART"))
		
	' --------------------------------------------------------------------------------------------
	' Load Localization
	' --------------------------------------------------------------------------------------------
	LOCALE.path = PATH_Locale
	LOCALE.language = GAME_LANGUAGE
	LOCALE.Load

	' --------------------------------------------------------------------------------------------
	' Set FLAGS
	' --------------------------------------------------------------------------------------------
	FLAG.Add("VSYNC", 1)										' VSYNC Flag
	FLAG.Add("DELAY", 0)										' Delay Flag
	FLAG.Add("BLUR", 1)											' Blur Flag
	FLAG.Add("WIREFRAME", 0)									' Wireframe Flag
	FLAG.Add("GUI", 1)											' GUI Flag
	FLAG.Add("FONT", 0)											' Font Detail Flag
	FLAG.Add("FPS", 1)											' FPS measurement
	FLAG.Add("TITLE", 1)										' Title Flag
	FLAG.Add("ORBITS", 1)										' Orbit Lines Flag
	FLAG.Add("ZONES", 0)										' Zones Flag
	FLAG.Add("GLOW", 1)											' Glow Flag
	FLAG.Add("PLANETS", 1)										' Planet ID Flag
	FLAG.Add("PATH", 1)											' Path Flag
	
	TIME.Start()
	
	' ------------------------------------------------------------------------------------------------
	' Create Main Window
	' ------------------------------------------------------------------------------------------------
	MAXGUI_WINDOW = CreateWindow(PROJECT_TITLE, SCREEN_CENTERX - (SCREEN_WIDTH / 2), SCREEN_CENTERY - (SCREEN_HEIGHT / 2), SCREEN_WIDTH, SCREEN_HEIGHT, Null, WINDOW_TITLEBAR)
	'SetGadgetColor(MAXGUI_WINDOW, 0, 0, 0)

	' ------------------------------------------------------------------------------------------------
	' Create Graphics Canvas in Main Window
	' ------------------------------------------------------------------------------------------------
	MAXGUI_CANVAS = CreateCanvas(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, MAXGUI_WINDOW)
	SetGadgetLayout MAXGUI_CANVAS, 1, 1, 1, 1
	ActivateGadget(MAXGUI_CANVAS)

	' ------------------------------------------------------------------------------------------------
	' miniB3D Graphics Mode settings
	' ------------------------------------------------------------------------------------------------
	'TGlobal.width = ClientWidth(MAXGUI_WINDOW)
	'TGlobal.Height = ClientHeight(MAXGUI_WINDOW)
	'TGlobal.depth = SCREEN_DEPTH
	'TGlobal.mode = SCREEN_MODE
	'TGlobal.rate = TIMER_Safe

	' ------------------------------------------------------------------------------------------------
	' Init Canvas Graphics
	' ------------------------------------------------------------------------------------------------
	SetGraphics CanvasGraphics(MAXGUI_CANVAS)
	TGlobal.GraphicsInit()
	UpdateScaler()
		
	TIME.Stop(LOCALE.Get("LOG_CREATECANVAS"))
		
	' --------------------------------------------------------------------------------------------
	' Create Camera
	' --------------------------------------------------------------------------------------------
		
	TIME.Start()
	
	' Main Camera
	CAMERA:TCam = New TCam
	CAMERA.parent = PIVOT_CAMERA
	CAMERA.Add()
	CAMERA.RangeMin = 0.01
	CAMERA.RangeMax = 100000
	CAMERA.speed = 1.0 * 0.1
	CAMERA.X = 0.0
	CAMERA.Y = 50.0
	CAMERA.Z = -125
	RotateEntity CAMERA.cam, 21.75, 0, 0
	CAMERA.TurnSpeed = 75.0
	CAMERA.RollSpeed = 50.0
	'CAMERA.MX = SCREEN_WIDTH / 2
	'CAMERA.MY = SCREEN_HEIGHT / 2
	CAMERA.zoom = 5
	CAMERA.UpdatePosition()
	CAMERA.Update()
					
	TIME.Stop(LOCALE.Get("LOG_CREATECAMERA"))

	' --------------------------------------------------------------------------------------------
	' Load MEDIA Files
	' --------------------------------------------------------------------------------------------
	LoadMedia()

	' --------------------------------------------------------------------------------------------
	' Create Objects
	' --------------------------------------------------------------------------------------------
	
	' --------------------------------------------------------------------------------------------
	' Milkyway
	' --------------------------------------------------------------------------------------------
	TIME.Start
	
	'CreateMilkyway()
	Cls
	RenderWorld
	Cls
	Flip False
	
	TIME.Stop(LOCALE.Get("LOG_CREATEMILKYWAY"))
						
	' --------------------------------------------------------------------------------------------
	' Mouse
	' --------------------------------------------------------------------------------------------
	CenterMouse()
	'HideMouse()
	
	' --------------------------------------------------------------------------------------------
	' Resolution
	' --------------------------------------------------------------------------------------------
	SetResolution(SCREEN_WIDTH, SCREEN_HEIGHT)
		
	TIME.TotalStop(LOCALE.Get("LOG_INITIALIZESTOP"))

End Function