' ------------------------------------------------------------------------------------------------
' Time measurement for subtasks
' ------------------------------------------------------------------------------------------------
Type TTime

	
	
	Global inittime:Int = 0								' init time
	Global starttime:Int = 0							' between start time
	Global PreviousTime:Int = 0							' previous time
	Global stoptime:Int = 0								' between stop time
	Global totaltime:Int = 0							' total time
	Global Debug:Int = True								' output debuglog infos

	

	' --------------------------------------------------------------------------------------------
	' METHOD: Total Time measurement START
	' --------------------------------------------------------------------------------------------
	Method TotalStart(output:String = "")

		Local t:TTime = New TTime

		inittime = MilliSecs()
		
		If output Then LogUpdate(output)

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Total Time measurement STOP
	' --------------------------------------------------------------------------------------------
	Method TotalStop(output:String = "")

		totaltime = MilliSecs() - inittime
				
		If output Then LogUpdate(output + " " + totaltime + "ms")

	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Between Time measurement START
	' --------------------------------------------------------------------------------------------
	Method Start(output:String = "")

		starttime = MilliSecs()
		PreviousTime = MilliSecs()

		If output Then LogUpdate(output)

	End Method

	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Current Time measurement since last current time measurement
	' --------------------------------------------------------------------------------------------
	Method ElapsedTime:Int(output:String = "")

		Local elapsed:Int = MilliSecs() - PreviousTime
		PreviousTime = MilliSecs()

		Return elapsed
		
	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Between Time measurement STOP
	' --------------------------------------------------------------------------------------------
	Method Stop(output:String = "")

		stoptime = MilliSecs() - starttime

		If output Then LogUpdate(output + " in " + stoptime + "ms")

	End Method



End Type