SuperStrict

Import "gfx/blitz.o"
Import "include\Extern\simplexnoise.cpp"

Framework brl.GLMax2D

Import sidesign.MiniB3D

Import brl.tgaloader
Import brl.pngloader
Import brl.oggloader
Import brl.wavloader
Import brl.jpgloader

Import brl.Pixmap
Import brl.Random
Import brl.timer
Import brl.EventQueue
Import brl.DirectSoundAudio
Import brl.FreeTypeFont
Import brl.Map

Import bah.DBSQLite													' SQlite database extension
Import bah.RegEx													' Regular Expression extension


Import maxgui.Drivers
Import maxgui.ProxyGadgets
Import maxgui.localization

Global n:TSimplex = New TSimplex

Global sin1:Float
Global sin2:Float
Global start:Int
Global cn:Int
Global smesh:TMesh
Global ssurf:TSurface

Global oldx:Float
Global oldy:Float
Global oldz:Float

Global lmesh:TMesh
Global lsurf:TSurface

Global player:TMesh
Global dummy:TMesh
Global elitediff:Float = 265.0

Global TICK:TTimer = CreateTimer(1000)


Type TPath

	Field id:Int
	Field x:Float
	Field y:Float
	Field z:Float
	Field q:TQuad
	
	Field starname:String

End Type

Global list:TList = CreateList()

Global MOUSE:Int



' ------------------------------------------------------------------------------------------------
' Audio Driver
' ------------------------------------------------------------------------------------------------
?Win32
SetAudioDriver "directsound"
?MacOs
SetAudioDriver "freeaudio"
?



' ------------------------------------------------------------------------------------------------
' Sourcecode Include
' ------------------------------------------------------------------------------------------------

Include "include\System\GUI.bmx"
Include "include\System\Init.bmx"
Include "include\System\Media.bmx"
Include "include\System\Objects.bmx"
Include "include\System\System.bmx"
Include "include\System\Variables.bmx"

Include "include\Functions\F3D.bmx"
Include "include\Functions\FBanks.bmx"
Include "include\Functions\FLog.bmx"
Include "include\Functions\FMath.bmx"
Include "include\Functions\FMouse.bmx"
Include "include\Functions\FNoise.bmx"
Include "include\Functions\FPixel.bmx"
Include "include\Functions\FPixmap.bmx"
Include "include\Functions\FQuaternion.bmx"
Include "include\Functions\FRandom.bmx"
Include "include\Functions\FText.bmx"
Include "include\Functions\FWin32.bmx"
Include "include\Functions\FWorld.bmx"

'Include "include\Types\TAsteroid.bmx"
Include "include\Types\TBeat.bmx"
Include "include\Types\TCam.bmx"
Include "include\Types\TConfig.bmx"
Include "include\Types\TFlag.bmx"
Include "include\Types\TFPS.bmx"
'Include "include\Types\TGradient.bmx"
'Include "include\Types\TInfotext.bmx"
Include "include\Types\TLocale.bmx"
Include "include\Types\TMedia.bmx"
'Include "include\Types\TMilkyway.bmx"
'Include "include\Types\TMouse.bmx"
'Include "include\Types\TPlanet.bmx"
'Include "include\Types\TQuad.bmx"
'Include "include\Types\TSimplex.bmx"
'Include "include\Types\TSystem.bmx"
Include "include\Types\TTime.bmx"


Global db:TDBConnection
Global q:TDatabaseQuery
Global mx:Int

Global o:TPath
Global p:TPath
Global galaxy:TMesh
Global bubble:TMesh

'Global pivot:TPivot


' ------------------------------------------------------------------------------------------------
' Initialize
' ------------------------------------------------------------------------------------------------
AppTitle = PROJECT_TITLE

GLShareContexts()

SeedRnd 42

' ------------------------------------------------------------------------------------------------
' Initialize Game
' ------------------------------------------------------------------------------------------------
Global qx:TQuad
Global tourlist:TList = CreateList()
Global xmesh:TMesh = CreateMesh(pivot)
Global xsurf:TSurface = CreateSurface(xmesh)
EntityFX xmesh, 1 + 2
'EntityBlend xmesh, 3
PositionEntity xmesh, 0, 0, 0
EntityOrder xmesh, -1000

Global qc:TQuad
Global connectlist:TList = CreateList()
Global cmesh:TMesh = CreateMesh(pivot)
Global csurf:TSurface = CreateSurface(cmesh)
EntityFX cmesh, 1 + 2
'EntityBlend xmesh, 3
PositionEntity cmesh, 0, 0, 0
EntityOrder cmesh, -1000

InitGame()
Init()




Local qs:TQuad
Global starlist:TList = CreateList()
Global qmesh:TMesh = CreateMesh(pivot)
Global qsurf:TSurface = CreateSurface(qmesh)
EntityFX qmesh, 1 + 2
EntityBlend qmesh, 3
PositionEntity qmesh, 0, 0, elitediff

Local qn:TQuad
Global nebulalist:TList = CreateList()
Global nmesh:TMesh = CreateMesh(pivot)
Global nsurf:TSurface = CreateSurface(nmesh)
EntityFX nmesh, 1 + 2 + 32
EntityBlend nmesh, 3
EntityOrder nmesh, -1
PositionEntity nmesh, 0, 0, elitediff

Local qd:TQuad
Global dustlist:TList = CreateList()
Global dmesh:TMesh = CreateMesh(pivot)
Global dsurf:TSurface = CreateSurface(dmesh)
EntityFX dmesh, 1 + 2 + 32
EntityBlend dmesh, 1
'EntityOrder dmesh, -1
PositionEntity dmesh, 0, 0, elitediff

'ScaleTexture MEDIA.GetTexture("STAR"), 2, 1
EntityTexture qmesh, MEDIA.GetTexture("STAR")
TextureBlend MEDIA.GetTexture("STAR"), 5

ScaleTexture MEDIA.GetTexture("NEBULA"), 4, 4
EntityTexture nmesh, MEDIA.GetTexture("NEBULA")
TextureBlend MEDIA.GetTexture("NEBULA"), 3

ScaleTexture MEDIA.GetTexture("DUST"), 4, 4
EntityTexture dmesh, MEDIA.GetTexture("DUST")
TextureBlend MEDIA.GetTexture("DUST"), 5

'ScaleTexture MEDIA.GetTexture("DOT"), 2, 1
'EntityTexture xmesh, MEDIA.GetTexture("DOT")
TextureBlend MEDIA.GetTexture("DOT"), 1

EntityTexture xmesh, MEDIA.GetTexture("DETAIL")
TextureBlend MEDIA.GetTexture("DETAIL"), 3


Global stp:Int = 8
Local ss:Int = Ceil(500.0 / ((2 * stp) + 1))

' stars
For Local i:Int = 1 To 20000


	qs = New TQuad
	qs.mesh = qmesh
	qs.surf = qsurf
		
	qs.x = Rnd(-ss, ss)
	qs.y = Rnd(Rnd(-ss * 0.75, -ss * 0.25), Rnd(ss * 0.25, ss * 0.75))
	qs.z = Rnd(-ss, ss)
	
	Local c:Float = Noise3D((qs.x + ss) / (2 * ss), (qs.y + ss * 0.5) / (2 * ss * 0.5), (qs.z + ss) / (2 * ss), 42, 3, 0.79, 0.125)
	c = Normalize(c, -0.5, 0.5, 0.1, 1)' *
	
	Local s:Float = Rnd(0.1, 1.0)
			
	qs.scalex = (1.0 / 32 + (1.0 / 16 * c)) * s
	qs.scaley = (1.0 / 32 + (1.0 / 16 * c)) * s
	
	Local col:Int = 0
	Local row:Int = 0
	
	' star distribution
	If Rnd(1) > 0.70 Then
	
		row = 1
			
		If Rnd(1) > 0.7 Then
		
			row = Rand(2, 3)
			If Rnd(1) > 0.7 Then row = Rand(4, 7)
			
		EndIf
		
	EndIf
	
	If Rnd(1) > 0.99 Then col = 1
		
	' scale them randomly
	If row > 0 Then

		qs.scalex:*Sqr(row * s)
		qs.scaley:*Sqr(row * s)
		
	EndIf
	
	col = 1
	
	Select row
	
		Case 0 qs.RGB = [128, 16, 8]		' M
		Case 1 qs.RGB = [64, 32, 0]		' K
		Case 2 qs.RGB = [96, 64, 32]	' G
		Case 3 qs.RGB = [128, 128, 64]	' F
		Case 4 qs.RGB = [160, 160, 160] ' A
		Case 5 qs.RGB = [32, 96, 192]	' B
		Case 6 qs.RGB = [48, 48, 255]	' O
		Case 7 qs.RGB = [192, 128, 255]	' W

	End Select
	
	' add to list
	qs.Add(col, 0, False)
	ListAddLast(starlist, qs)
					
Next

Local nebulae:Int = 1000

' nebulae
For Local i:Int = 1 To nebulae

	qn = New TQuad
	qn.mesh = nmesh
	qn.surf = nsurf

	Local arms:Int = 2
	Local Range:Float = 500.0
	Local spread:Float = 80.0
	Local rot:Float = 2.0

	Local multi:Float
	Local turb:Float
	Local lum:Float
	Local dist:Float
	Local bulge:Float
	
	Local angle:Int = Int(Floor(i * 1.0 / (nebulae / arms))) * (360.0 / arms) - 45
	
	' distance
	multi = Rnd(0.5, 1)
	dist = Rnd(0, Range) * Rnd(1, Rnd(Rnd(multi)))
	
	' distance And turbulence	
	turb = Rnd(0, Rnd(spread))
	If Rnd(1) > 0.5 Then turb = -turb
		
	' star position x/z
	qn.x = dist * Cos(angle + (dist * rot)) + Rnd(Rnd(Rnd(-spread)), Rnd(Rnd(spread)))
	qn.z = dist * Sin(angle + (dist * rot)) + Rnd(Rnd(Rnd(-spread)), Rnd(Rnd(spread)))

	' star position y
	bulge = Normalize(Distance2D(qn.x, qn.z, 0, 0), 0, Range / 2.0, 0, 180) / 2.0
	If bulge > 90 Then bulge = 90
	qn.y = (Cos(bulge) * Rnd(Rnd(-spread), Rnd(spread)) / 5.0) + (turb / 10.0)

	' center / arm relation
	If dist < Range / 2.0 Then
	
		Local col1:Int[] = [255, 0, 0]
		Local col2:Int[] = [255, 255, 0]
		
		If Rnd(1) > 0.5 Then qn.RGB1 = col1 Else qn.RGB1 = col2
		If Rnd(1) > 0.5 Then qn.RGB2 = col1 Else qn.RGB2 = col2
		If Rnd(1) > 0.5 Then qn.RGB3 = col1 Else qn.RGB3 = col2
		If Rnd(1) > 0.5 Then qn.RGB4 = col1 Else qn.RGB4 = col2
		
		Local am:Float = 1.0 / Sqr(dist)
		qn.Alpha1 = Rnd(0, am)
		qn.Alpha2 = Rnd(0, am)
		qn.Alpha3 = Rnd(0, am)
		qn.Alpha4 = Rnd(0, am)
	
	Else
	
		Local col1:Int[] = [255, 0, 0]
		Local col2:Int[] = [0, 0, 255]
		
		If Rnd(1) > 0.5 Then qn.RGB1 = col1 Else qn.RGB1 = col2
		If Rnd(1) > 0.5 Then qn.RGB2 = col1 Else qn.RGB2 = col2
		If Rnd(1) > 0.5 Then qn.RGB3 = col1 Else qn.RGB3 = col2
		If Rnd(1) > 0.5 Then qn.RGB4 = col1 Else qn.RGB4 = col2
	
		Local am:Float = 2.0 / Sqr(dist)
		qn.Alpha1 = Rnd(0, am)
		qn.Alpha2 = Rnd(0, am)
		qn.Alpha3 = Rnd(0, am)
		qn.Alpha4 = Rnd(0, am)

	EndIf
		
	qn.scalex = (1.0 - (1.0 / dist)) * (Range - dist) / 2.0
	If qn.scalex > 20 Then qn.scalex = 20
	If qn.scalex < 5 Then qn.scalex = 5
	qn.scaley = qn.scalex * Rnd(0.75, 1.25)
    qn.rotation = Rnd(360)

	' add to list
	qn.Add(Rand(0, 3), Rand(0, 3), True)
	ListAddLast(nebulalist, qn)

Next

Local dust:Int = 500

' nebulae
For Local i:Int = 1 To dust

	qd = New TQuad
	qd.mesh = dmesh
	qd.surf = dsurf

	Local arms:Int = 2
	Local Range:Float = 500.0
	Local spread:Float = 80.0
	Local rot:Float = 2.0

	Local multi:Float
	Local turb:Float
	Local lum:Float
	Local dist:Float
	Local bulge:Float
	
	Local angle:Int = Int(Floor(i * 1.0 / (dust / arms))) * (360.0 / arms) - 45
	
	' distance
	multi = Rnd(0.5, 1)
	dist = Rnd(Range * 0.5, Range) * Rnd(1, Rnd(Rnd(multi)))
	
	' distance And turbulence	
	turb = Rnd(0, Rnd(spread))
	If Rnd(1) > 0.5 Then turb = -turb
		
	' star position x/z
	qd.x = dist * Cos(angle + (dist * rot)) + Rnd(Rnd(Rnd(-spread)), Rnd(Rnd(spread)))
	qd.z = dist * Sin(angle + (dist * rot)) + Rnd(Rnd(Rnd(-spread)), Rnd(Rnd(spread)))

	' star position y
	bulge = Normalize(Distance2D(qd.x, qd.z, 0, 0), 0, Range / 2.0, 0, 180) / 2.0
	If bulge > 90 Then bulge = 90
	qd.y = (Cos(bulge) * Rnd(Rnd(-spread), Rnd(spread)) / 10.0) + (turb / 10.0)
	
	Local col1:Int[] = [32, 32, 32]
	Local col2:Int[] = [96, 96, 96]
	
	If Rnd(1) > 0.5 Then qd.RGB1 = col1 Else qd.RGB1 = col2
	If Rnd(1) > 0.5 Then qd.RGB2 = col1 Else qd.RGB2 = col2
	If Rnd(1) > 0.5 Then qd.RGB3 = col1 Else qd.RGB3 = col2
	If Rnd(1) > 0.5 Then qd.RGB4 = col1 Else qd.RGB4 = col2
	
	Local am:Float = 2.0 / Sqr(dist)
	qd.Alpha1 = Rnd(0, am)
	qd.Alpha2 = Rnd(0, am)
	qd.Alpha3 = Rnd(0, am)
	qd.Alpha4 = Rnd(0, am)

	qd.scalex = (1.0 - (1.0 / dist)) * (Range - dist) / 2.0
	If qd.scalex > 20 Then qd.scalex = 20
	If qd.scalex < 5 Then qd.scalex = 5
	qd.scaley = qd.scalex * Rnd(0.25, 1.75)
    qd.rotation = 0'Rnd(360)

	' add to list
	qd.Add(Rand(0, 3), Rand(0, 3), True)
	
	ListAddLast(dustlist, qd)

Next

' multiply star box
Global qmeshes:TEntity[99, 99, 99]

For Local x:Int = -stp To stp Step 1
	
	For Local z:Int = -stp To stp Step 1
	
		qmeshes[x + stp, 0, z + stp] = CopyEntity(qmesh, PIVOT)
		
		PositionEntity qmeshes[x + stp, 0, z + stp], x * ss * 2, 0, (z * ss * 2) + elitediff
		
	Next

Next

PositionMesh qmesh, Rnd(-10, 10), Rnd(-10, 10), Rnd(-10, 10)

Global ms:Int = MilliSecs()
Global MSS:Int = MilliSecs()


'Global music:TSound = LoadSound("music/Kevin MacLeod - It is lost.ogg", SOUND_LOOP)
'Global channel:TChannel = CueSound(music)
'ResumeChannel(channel)


SetImageFont(MEDIA.GetFont("EURO"))

' ------------------------------------------------------------------------------------------------
' Main Loop
' ------------------------------------------------------------------------------------------------
Global initializing:Int = MilliSecs()
AddHook EmitEventHook, EventHook

While Not AppTerminate()

Wend

End



' ------------------------------------------------------------------------------------------------
' Update Game Logic
' ------------------------------------------------------------------------------------------------
Function MainLoop()


	
	' read current time
	TIMER_Timer = MilliSecs()

	' check if update is allowed
	If (TIMER_Timer > TIMER_Update + TIMER_Lasttimer) Then

		' calculate new timer interval		
		TIMER_Interval = TIMER_Timer - TIMER_Lasttimer

		If TIMER_Interval > TIMER_Safe Then

			' check for framedrops
			TIMER_Interval = TIMER_Safe
			FPS.framedrops:+1

		End If
		
		FPS.multi = GAME_SPEED * TIMER_Interval
		
		'RenderWorld
	
		'GCCollect()
		
		'Flip False

		' store last timer
		TIMER_Lasttimer = TIMER_Timer
			
	EndIf

End Function

' ------------------------------------------------------------------------------------------------
' Events
' ------------------------------------------------------------------------------------------------
Function EventHook:Object(id:Int, Data:Object, Context:Object)

	Local Event:TEvent = TEvent(data)
	If Event = Null Then Return Event

	Select Event.id

		Case EVENT_WINDOWCLOSE
								End

		Case EVENT_APPTERMINATE
								End

		Case EVENT_TIMERTICK
								Select Event.Source
								
									Case SCREEN_TIMER
														
											' Update Camera
														CAMERA.MoveTest
														'CAMERA.zoom = 1.0 + (MouseWheel / 10.0)
														CAMERA.zoom = 1.0
														
														'If CAMERA.zoom - 0.0125 > 1 Then CAMERA.zoom:-0.0125
																		
														'UpdateGUI()
														
														CAMERA.Update()
														CAMERA.GetCameraPosition
						
														Select MOUSE
														
															Case 1
																		If TICK.Ticks() Mod 100 = 0 Then cn:+MouseWheel
																		If cn > mx Then cn = mx
																		
															Case 2
																		If TICK.Ticks() Mod 100 = 0 Then cn:-MouseWheel
																		If cn < 1 Then cn = 0
																		
														End Select
														
														
														
									Case CANVAS_TIMER
														
														RedrawGadget MAXGUI_CANVAS

								End Select
								
								

		Case EVENT_GADGETPAINT
								
								SetGraphics CanvasGraphics(MAXGUI_CANVAS)



								Cls

								UpdateTour()
								
								MainLoop()
								
								For Local s:TQuad = EachIn starlist

									s.Update(CAMERA.cam)
	
								Next
								
								For Local n:TQuad = EachIn nebulalist

									n.UpdateRotation(CAMERA.cam)
	
								Next

								For Local d:TQuad = EachIn dustlist

									d.Update(CAMERA.cam)
	
								Next
								
								
								
								For Local x:TQuad = EachIn tourlist
								
									Local d:Float = Distance3D(x.x, x.y, x.z, CAMERA.x, CAMERA.Y, CAMERA.z)
								
									x.scalex = d / Sqr(d * 2500)'1000.0' * (100.0 / d)
									x.scaley = x.scalex
								
									x.Update(CAMERA.cam)
									
								Next


								' distance alpha of star boxes
								For Local x:Int = -stp To stp Step 1
									
									For Local z:Int = -stp To stp Step 1
																		
										Local h1:Float = Normalize(Distance3D(camera.X, camera.Y, camera.z, EntityX(qmeshes[x + stp, 0, z + stp]), EntityY(qmeshes[x + stp, 0, z + stp]), EntityZ(qmeshes[x + stp, 0, z + stp])), 0, 1000, 1, 0)
										'Local h2:Float = Normalize(Distance3D(0, 0, 0, EntityX(qmeshes[x + stp, 0, z + stp]), EntityY(qmeshes[x + stp, 0, z + stp]), EntityZ(qmeshes[x + stp, 0, z + stp])), 0, 400, 1, 0)
										
										HideEntity qmeshes[x + stp, 0, z + stp]
										
										If h1 < 0 Then h1 = 0
										'If h2 < 0 Then h2 = 0
										
										If h1 > 0.8 Then
										
											ShowEntity qmeshes[x + stp, 0, z + stp]
											EntityAlpha qmeshes[x + stp, 0, z + stp], h1
											
										EndIf
																				
									Next
									
								Next
								
								
								
								Local a:Float = Normalize(Distance3D(0, 0, 0, CAMERA.x, CAMERA.y, CAMERA.z), 0, 500, 0.1, 0.25)
								If a > 0.25 Then a = 0.25
								If a < 0.1 Then a = 0.1
								
								EntityAlpha galaxy, 1.0 - (1.0 / (1.0 + Abs(CAMERA.y / 10.0)))
								
								FPS.Update()
								
								RenderWorld
								
								'Cls
								
								rem
								
								' normal render pass
								ShowEntity PIVOT
								EntityColor bubble, 0, 128, 255
								EntityAlpha bubble, a
								Wireframe FLAG.Get("WIREFRAME")
								'HideEntity bubble
								RenderWorld
								CameraClsMode CAMERA.cam, 0, 0

								' wireframe render pass
								HideEntity PIVOT
								'ShowEntity bubble
								EntityColor bubble, 0, 128, 255
								EntityAlpha bubble, 0.25
								Wireframe True
								RenderWorld
								
								CameraClsMode CAMERA.cam, 1, 1

								
								endrem
																

								
								glEnable(GL_BLEND)
								glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
								glEnable(GL_COLOR_MATERIAL)
								glLineWidth(1.0)
								glDepthMask(GL_FALSE)
								glBegin(GL_LINES)
								
								Local lc:Int = 0
																
								For Local x:TQuad = EachIn tourlist
								
									Local d:Float = Distance3D(x.x, x.y, x.z, CAMERA.x, CAMERA.Y, CAMERA.z)
									
									If d < 1000 Then
									
										TFormPoint(x.x, x.y, x.z, Null, CAMERA.cam)
										
										If TFormedZ() > 0 Then
								
											If lc = 0 Then oldx = x.x ; oldy = x.y ; oldz = x.z
											
											CameraProject(CAMERA.cam, x.x, x.y, x.z)
											Local px1:Int = ProjectedX()
											Local py1:Int = ProjectedY()
											Local pz1:Int = ProjectedZ()
											
											SetAlpha(Normalize(d, 0, 10, 1, 0))
												
											CameraProject(CAMERA.cam, oldx, oldy, oldz)
											Local px2:Int = ProjectedX()
											Local py2:Int = ProjectedY()
																						
											If (pz1 >= 0 And px1 > 0 And px1 < 1920 And py1 > 0 And py1 < 1080) Then
											
												Line3D(x.x, x.y, x.z, oldx, oldy, oldz, 0, 255, 0, 0.5)
												
											EndIf
											
											oldx = x.x
											oldy = x.y
											oldz = x.z
											
										EndIf
										
									EndIf
									
									lc:+1
									
								Next
								
								glDisable(GL_COLOR_MATERIAL)
								glDepthMask(GL_TRUE)
								glEnd()
								
								
								BeginMax2D()
								
								SetBlend ALPHABLEND
								
								DrawText "FPS: " + FPS.FPS, 0, 0
								DrawText "POS: " + cn, 0, 15
								'DrawText TICK.Ticks(), 0, 30
								DrawText "INC: " + MouseWheel, 0, 30

								'rem
								
								SetColor(255, 0, 255)
																
								For Local x:TQuad = EachIn tourlist
								
									Local d:Float = Distance3D(x.x, x.y, x.z, CAMERA.x, CAMERA.Y, CAMERA.z)
									
									If d < 10 Then
									
										TFormPoint(x.x, x.y, x.z, Null, CAMERA.cam)
										
										If TFormedZ() > 0 Then									
								
											CameraProject(CAMERA.cam, x.x, x.y, x.z)
											Local px1:Int = ProjectedX()
											Local py1:Int = ProjectedY()
											
											
											If (ProjectedZ() >= 0 And px1 > 0 And px1 < 1920 And py1 > 0 And py1 < 1080) Then
											
												SetAlpha(Normalize(d, 5, 10, 1, 0))
												DrawText(x.cat, px1 - TextWidth(x.cat) / 2, py1 + TextHeight(x.cat))
												
											EndIf
											
										EndIf
										
									EndIf
									
								Next
								
								SetAlpha(1.0)

								
								For Local i:Int = 0 To 0
								
									Local i1:Int = cn - 1
									Local i2:Int = cn
									
									If i1 < 0 Then i1 = 0
									
									p = TPath(list.ValueAtIndex(i1 + i))
								
								
	'							For Local i:TPath = EachIn list
								
									'Local i1:Int = cn - 25
									'Local i2:Int = cn + 25
								
									'If i.id < cn Then
									
										PositionEntity player, p.x / 100.0, p.y / 100.0, p.z / 100.0
								
										Local d:Float = Distance3d(p.x / 100.0, p.y / 100.0, p.z / 100.0, camera.X, camera.Y, camera.Z)
										
										TFormPoint(p.x / 100.0, p.y / 100.0, p.z / 100.0, Null, CAMERA.cam)
										
										If TFormedZ() > 0 Then'And d < 250 Then
										
											CameraProject(CAMERA.cam, p.x / 100.0, p.y / 100.0, p.z / 100.0)
											
											Local x:Int = ProjectedX()
											Local y:Int = ProjectedY()
											
											'SetBlend SOLIDBLEND
																					
											SetColor(0, 255, 0)
											DrawText p.starname, x + 100, y - 100 - TextHeight("X")
											
											DrawLine(x, y, x + 100, y - 100)
										
										EndIf
										
									'EndIf
								
								Next
								
								'wwsendrem
								
								EndMax2D()

								
								' Bufferflip
								Flip False'FLAG.Get("VSYNC")

								
								' Memory Garbage Collection
								GCCollect()
								
								Text FPS.FPS, 0, 0								
								' let the OS breathe
								Delay FLAG.Get("DELAY")

		Case EVENT_KEYDOWN
								
								Select Event.Data
																
									' Player Movement
									Case KEY_W
													PlayerZSpeed = 1
									Case KEY_S
													PlayerZSpeed = -1
									Case KEY_A
													PlayerXSpeed = 1
									Case KEY_D
													PlayerXSpeed = -1
									Case KEY_R
													PlayerYSpeed = 1
									Case KEY_F
													PlayerYSpeed = -1
									Case KEY_Q
													PlayerVXSpeed = -1
									Case KEY_E
													PlayerVXSpeed = 1
									Case KEY_X
													PlayerBrake = 1
													PlayerZSpeed = 0
													PlayerYSpeed = 0
													PlayerXSpeed = 0
													
									Case KEY_LSHIFT
													PlayerTurbo = 1
													
									Case KEY_SPACE
													start = 1

									' System
									Case KEY_ESCAPE
													End
													
									Case KEY_TAB
													FLAG.Switch("WIREFRAME")
													
													
								End Select

		Case EVENT_KEYUP
		
								Select Event.Data
								
									' Player Movement
									Case KEY_W
													PlayerZSpeed = 0
													
									Case KEY_S
													PlayerZSpeed = 0
													
									Case KEY_A
													PlayerXSpeed = 0
													
									Case KEY_D
													PlayerXSpeed = 0

									Case KEY_R
													PlayerYSpeed = 0
													
									Case KEY_F
													PlayerYSpeed = 0
													
									Case KEY_Q
													PlayerVXSpeed = 0
													
									Case KEY_E
													PlayerVXSpeed = 0
													
									Case KEY_X
													PlayerBrake = 0
													
									Case KEY_LSHIFT
													PlayerTurbo = 0
													
								End Select
								
		Case EVENT_MOUSEWHEEL
						
								If Event.Data > 0 Then

									MouseWheel:+1
									If MouseWheel > 50 Then MouseWheel = 50

								Else

									MouseWheel:-1
									If MouseWheel < 1 Then MouseWheel = 1

								EndIf
																

		Case EVENT_MOUSEMOVE
								CAMERA.MX = Event.x
								CAMERA.MY = Event.y
								
		Case EVENT_MOUSEDOWN
		
								MOUSE = 0
								
								Select Event.Data
								
									Case 1
												MOUSE = 1
												
									Case 2
												MOUSE = 2
								
								End Select
								
								
		Case EVENT_MOUSEUP
		
								MOUSE = 0

	End Select
	
End Function

Function Init()
	
	
	Local target:TPivot
	Local raster1:TMesh
	Local raster2:TMesh
	Local raster3:TMesh

	pivot = CreatePivot()
	target = CreatePivot(pivot)
	PositionEntity pivot, 0, 0, 0
	
	bubble = CreateSphere(32)
	EntityFX bubble, 1 + 16 + 32
	EntityOrder bubble, -1
	EntityColor bubble, 0, 128, 255
	ScaleEntity bubble, 5, 5, 5
	EntityAlpha bubble, 0.125
	EntityBlend bubble, 3
	FlipMesh bubble
	
	galaxy = CreateCube(pivot)
	EntityFX galaxy, 1 + 32' + 2 + 16 + 32
	ScaleEntity galaxy, -500, 0, 500
	PositionEntity galaxy, 0, 0, elitediff
	'EntityBlend galaxy, 3
	
	raster1 = CreateCube(PIVOT)
	EntityFX raster1, 1' + 2 + 16 + 32
	ScaleEntity raster1, -500, 0, 500
	PositionEntity raster1, 0, 0, elitediff
	EntityBlend raster1, 3
	EntityColor raster1, 128, 128, 128
	
	raster2 = CreateCube(PIVOT)
	EntityFX raster2, 1' + 2 + 16 + 32
	ScaleEntity raster2, -500, 0, 500
	PositionEntity raster2, 0, 0, elitediff
	EntityBlend raster2, 3
	EntityColor raster2, 192, 192, 192

	raster3 = CreateCube(PIVOT)
	EntityFX raster3, 1' + 2 + 16 + 32
	ScaleEntity raster3, -500, 0, 500
	PositionEntity raster3, 0, 0, elitediff
	EntityBlend raster3, 3
	EntityColor raster3, 255, 255, 255
	
	EntityAlpha raster1, 1
	EntityAlpha raster2, 0.5
	EntityAlpha raster3, 0.25
	
	'PositionTexture MEDIA.GetTexture("RASTER2"), 1.0 / 50, 1.0 / 50
	'PositionTexture MEDIA.GetTexture("RASTER3"), 1.0 / 50, 1.0 / 50
	
			
	'TextureBlend MEDIA.GetTexture("GALAXY"), 1
	EntityTexture galaxy, MEDIA.GetTexture("GALAXY")

	EntityTexture raster1, MEDIA.GetTexture("RASTER1")
	EntityTexture raster2, MEDIA.GetTexture("RASTER2")
	EntityTexture raster3, MEDIA.GetTexture("RASTER3")
	
	TextureBlend MEDIA.GetTexture("RASTER1"), 5
	TextureBlend MEDIA.GetTexture("RASTER2"), 5
	TextureBlend MEDIA.GetTexture("RASTER3"), 5
	
	ScaleTexture MEDIA.GetTexture("RASTER1"), 1.0 / 2000, 1.0 / 2000
	ScaleTexture MEDIA.GetTexture("RASTER2"), 1.0 / 200, 1.0 / 200
	ScaleTexture MEDIA.GetTexture("RASTER3"), 1.0 / 20, 1.0 / 20
	
	EntityOrder raster1, -1
	EntityOrder raster2, -2
	EntityOrder raster3, -3

	'raster = LoadTexture("gfx/raster.png", 2)
	'EntityTexture galaxy, raster, 0, 1
	'TextureBlend raster, 3
	'ScaleTexture raster, 1.0 / 200, 1.0 / 200
	
	player = CreateSphere(4, PIVOT)
	EntityFX player, 1
	EntityColor player, 255, 0, 0
	ScaleEntity player, 0.1, 0.1, 0.1
	EntityOrder player, -1
	
	PointEntity CAMERA.cam, player
	
	smesh = CreateMesh(PIVOT)
	ssurf = CreateSurface(smesh)
	EntityFX smesh, 1 + 2
	EntityOrder smesh, -1

	lmesh = CreateMesh(PIVOT)
	lsurf = CreateSurface(lmesh)
	EntityFX lmesh, 1 + 2 + 16 + 32
	EntityOrder lmesh, -1

	db = LoadDatabase("SQLITE", "CMDR.db")
	q = db.executeQuery("SELECT * from system ORDER by lastvisit ASC")
	
	Local cnt:Int = 0
	
	While q.nextRow()
	
		Local p:TPath = New TPath
		
		Local r:TQueryRecord = q.rowRecord()
		
		p.id = cnt
				
		p.x = r.getFloatByName("x")
		p.y = r.getFloatByName("y")
		p.z = r.getFloatByName("z")
		p.starname = r.getStringByName("name")
		
		qx = New TQuad
		qx.x = p.x / 100.0
		qx.y = p.y / 100.0
		qx.z = p.z / 100.0
		
		qx.mesh = xmesh
		qx.surf = xsurf
		
		sin1:+0.25
		sin2:+0.5
		sin1 = sin1 Mod 360
		sin2 = sin2 Mod 360
		
		Local r1:Int = 0'Abs(Sin(sin2 / 2.0)) * 128
		Local g1:Int = 255'Abs(Cos(sin2 / 2.0)) * 128
		Local b1:Int = 0'Abs(Sin(sin2 / 2.0) + Cos(sin2 / 2.0)) * 128
		
		qx.RGB = [r1, g1, b1]
		
		qx.cat = p.starname
		
		qx.Add()
		
		p.q = qx
		
		ListAddLast(tourlist, qx)
		ListAddLast(list, p)
				
		cnt:+1
	
	Wend
	
	mx = cnt
	cn=mx

End Function

' ----------------------------------------------------------------------------
' Adds a mesh to another mesh
' ----------------------------------------------------------------------------
Function AddToMesh(mesh:TMesh, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)
	
	Local v:Int[3]
		
	Local surface:TSurface = GetSurface(mesh, 1)
	
	Local surf:TSurface = GetSurface(singlesurfaceentity, CountSurfaces(singlesurfaceentity))
	
	If CountVertices(surf) + CountVertices(surface) > 32768 Then surf = CreateSurface(singlesurfaceentity)
		
	For Local i1:Int = 0 To CountTriangles(surface) - 1
			
		For Local i2:Int = 0 To 2
					
			Local oldv:Int = TriangleVertex(surface, i1, i2)
			TFormPoint VertexX(surface, oldv), VertexY(surface, oldv), VertexZ(surface, oldv), mesh, singlesurfaceentity
			v[i2] = AddVertex(surf, TFormedX(), TFormedY(), TFormedZ(), VertexU(surface, oldv), VertexV(surface, oldv))
			
			VertexNormal surf, v[i2], VertexNX(surface, oldv), VertexNY(surface, oldv), VertexNZ(surface, oldv)
			
			VertexColor surf, v[i2], r, g, b, a
						
		Next
		
		AddTriangle(surf, v[0], v[1], v[2])
				
	Next
	
End Function


Function UpdateTour()

	rem

	Local s1:Float = 1.0 / 16
	Local s2:Float = 1.0 / 100

	If smesh Then
	
		FreeEntity smesh
		smesh = CreateMesh(PIVOT)
		EntityFX smesh, 1
		ssurf = CreateSurface(smesh)
		
	EndIf
	
	Local cube:TMesh = CreateSphere(4)
	ScaleEntity cube, s1, s1, s1
	
	Print cn
		
	For Local i:Int = 1 To cn
	
		p = TPath(list.ValueAtIndex(i - 1))
	
		PositionEntity cube, p.x * s2, p.y * s2, p.z * s2
		AddToMesh(cube, smesh, 255, 255, 255, 1.0)
		
	Next
	
	FreeEntity cube
	
	endrem

End Function


Function UpdateGUI()
	
	'SetGraphics CanvasGraphics(canvas)
	
	'MainLoop()
	
	Cls
	
	sin1:+(20 * FPS.multi)
	sin2:+(30 * FPS.multi)
	sin1 = sin1 Mod 360
	sin2 = sin2 Mod 360
						
	'SetViewport 0, 0, GadgetWidth(canvas), GadgetHeight(canvas)
	'CameraViewport cam, 0, 0, GadgetWidth(canvas), GadgetHeight(canvas)
	
	'If start And (Not ChannelPlaying(channel)) Then ResumeChannel(channel)
	
	
	If CountSurfaces(smesh) > 7 Then
	
		Print "NEW SMESH"
	
		smesh = CreateMesh(PIVOT)
		ssurf = CreateSurface(smesh)
		EntityFX smesh, 1 + 2
		EntityOrder smesh, -1
	
	EndIf
	
	If CountSurfaces(lmesh) > 7 Then
	
		Print "NEW LMESH"
	
		lmesh = CreateMesh(PIVOT)
		lsurf = CreateSurface(lmesh)
		EntityFX lmesh, 1 + 2 + 16 + 32
		EntityOrder lmesh, -1
	
	EndIf

	If start And cn < mx Then
	
		If cn > 1 Then o = TPath(list.ValueAtIndex(cn - 1))
	
		p = TPath(list.ValueAtIndex(cn))
						
		Local s1:Float = 1.0 / (100.0 / 50)
		Local s2:Float = 1.0 / 50
		Local s3:Float = 1.0 / 100
		Local s4:Float = 1.0 / 64
		
		Local r1:Int = Abs(Sin(sin2 / 2.0)) * 255
		Local g1:Int = Abs(Cos(sin2 / 2.0)) * 255
		Local b1:Int = Abs(Sin(sin2 / 2.0) + Cos(sin2 / 2.0)) * 255

		Local strip:TMesh = CreateSprite()
		ScaleEntity strip, s2, s2, s2
		EntityFX strip, 1	
		Local s:TSurface = GetSurface(strip, 1)
		VertexCoords s, 0, (o.x + 6) * s1, (o.y + 6) * s1, (o.z + 6) * s1 ' o1
		VertexCoords s, 1, (p.x + 6) * s1, (p.y + 6) * s1, (p.z + 6) * s1 ' p1
		VertexCoords s, 2, (p.x - 6) * s1, (p.y - 6) * s1, (p.z - 6) * s1 ' p2
		VertexCoords s, 3, (o.x - 6) * s1, (o.y - 6) * s1, (o.z - 6) * s1 ' o2
		AddToMesh(strip, lmesh, r1 / 2, g1 / 2, b1 / 2, 1.0)
		
		'VertexCoords s, 0, (o.x + 2) * s1, 0, (o.z + 2) * s1 ' o1
		'VertexCoords s, 1, (o.x + 2) * s1, (o.y + 2) * s1, (o.z + 2) * s1 ' p1
		'VertexCoords s, 2, (o.x - 2) * s1, (o.y - 2) * s1, (o.z - 2) * s1 ' p2
		'VertexCoords s, 3, (o.x - 2) * s1, 0, (o.z - 2) * s1 ' o2
		'AddToMesh(strip, lmesh, r1 / 2, g1 / 2, b1 / 2, 0.125)
		
		
		
		Local cube:TMesh = CreateSphere(4)
		ScaleEntity cube, s4, s4, s4
		EntityFX cube, 1
		'EntityOrder cube, -1
		PositionEntity cube, p.x * s3, p.y * s3, p.z * s3
		AddToMesh(cube, smesh, 255, 255, 255, 1.0)'r1 * 1.2, g1 * 1.2, b1 * 1.2, 1.0)

		FreeEntity cube
		FreeEntity strip
		
		PositionEntity player, p.x * s3, p.y * s3, p.z * s3
		
		cn:+1
		
	Else
	
		start = 0
		'PositionEntity player, 0, 0, 0
		
		'For Local i:Int = 1 To CountSurfaces(smesh)
		
		'	Print i + ": " + CountVertices(GetSurface(smesh, i))
		
		'Next

	EndIf
	
	'TurnEntity pivot, 0, 2 * FPS.multi, 0
	'TurnEntity smesh, 0, 2 * FPS.multi, 0
	'PositionEntity cam, 0, Cos(sin1) * 100, 100 + (Sin(sin2) * 100)
	'PointEntity cam, target
	
	'Wireframe 0

	
	'Delay 1

End Function


Function Noise3D:Float(x:Float, y:Float, z:Float, seed:Int, octaves:Int, persistence:Float, Scale:Float)

	x:+seed + 1
	y:+seed + 1
	z:+seed + 1

	Local total:Float = 0
	Local frequency:Float = scale
	Local amplitude:Float = 1
	Local maxamplitude:Float = 0
	
	For Local i:Int = 0 To octaves - 1
		
		total:+n.Noise_3D(x * frequency, y * frequency, z * frequency) * amplitude
		frequency:*2
		maxamplitude:+amplitude
		amplitude:*persistence
	
	Next
	
	Return total / maxamplitude

End Function


' keeps the player in a given distance While the world can Move far away
' ------------------------------------------------------------------------------------------------
' Quad Type
' ------------------------------------------------------------------------------------------------
Type TQuad

	Field x:Float = 0.0										' position x
	Field y:Float = 0.0										' position y
	Field z:Float = 0.0										' position z
	
	Field xx1:Float
	Field yy1:Float
	Field zz1:Float
	
	Field xx2:Float
	Field yy2:Float
	Field zz2:Float
	
	Field pitch:Float = 0.0
	Field yaw:Float = 0.0
	Field roll:Float = 0.0
	
	Field row:Int = 0										' texture row
	Field col:Int = 0										' texture column
	Field cat:String = ""
	
	Field size:Float = 1.0									' base size
	Field scale:Float = 1.0									' base scale
	Field scalex:Float = 1.0								' current size X
	Field scaley:Float = 1.0								' current size Y
	Field distance:Float = 0.0								' distance to cam
	Field Hidden:Int = 0									' hidden flag
	Field vanish:Float = 1.0								' vanish rate
	Field expanding:Float = 1.0								' expand rate
	
	Field RGB:Int[] = [255, 255, 255, 255]					' star vertex color

	Field RGB1:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB2:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB3:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB4:Int[] = [255, 255, 255, 255]					' nebula vertex color

	Field Alpha:Float = 1.0									' vertex alpha
	Field Alpha1:Float = 1.0								' vertex alpha #1
	Field Alpha2:Float = 1.0								' vertex alpha #2
	Field Alpha3:Float = 1.0								' vertex alpha #3
	Field Alpha4:Float = 1.0								' vertex alpha #4

	Field v:Int = 0											' vertex counter
	Field mesh:TMesh = Null									' mesh pointer
	Field surf:TSurface = Null								' surface pointer

	Field rotation:Float
				
	Global temp:TPivot = CreatePivot()


	' --------------------------------------------------------------------------------------------
	' METHOD: Add new Quad
	' --------------------------------------------------------------------------------------------
	Method Add(col:Int = 0, row:Int = 0, modus:Int = 0)

		' surface setup
		If surf = Null Then surf = surf
		If v + 4 > 32768 Then
			v = 0
			surf = CreateSurface(mesh)
		EndIf

		' add Vertices
		Local V0:Int = AddVertex(surf, 0, 0, 0, 1, 0)
		Local V1:Int = AddVertex(surf, 0, 0, 0, 1, 1)
		Local V2:Int = AddVertex(surf, 0, 0, 0, 0, 1)
		Local V3:Int = AddVertex(surf, 0, 0, 0, 0, 0)

		If modus = 0 Then
		
			' color vertices
			VertexColor surf, V0, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V1, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V2, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V3, RGB[0], RGB[1], RGB[2], Alpha
			
		Else
		
			' color vertices
			VertexColor surf, V0, RGB1[0], RGB1[1], RGB1[2], Alpha1
			VertexColor surf, V1, RGB2[0], RGB2[1], RGB2[2], Alpha2
			VertexColor surf, V2, RGB3[0], RGB3[1], RGB3[2], Alpha3
			VertexColor surf, V3, RGB4[0], RGB4[1], RGB4[2], Alpha4

		EndIf

		' connect triangles
		AddTriangle surf, V0, V1, V2
		AddTriangle surf, V0, V2, V3
		
		VertexTexCoords surf, V0, col + 1, row
		VertexTexCoords surf, V1, col + 1, row + 1
		VertexTexCoords surf, V2, col, row + 1
		VertexTexCoords surf, V3, col, row

		' increase vertex counter
		If v >= 4 Then v = V0 + 4 Else v = V0

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Hide a Quad
	' --------------------------------------------------------------------------------------------
	Method Hide()

		distance = 2 ^ 32

		' set vertices
		VertexCoords surf, v + 0, distance, distance, distance
		VertexCoords surf, v + 1, distance, distance, distance
		VertexCoords surf, v + 2, distance, distance, distance
		VertexCoords surf, v + 3, distance, distance, distance

		hidden = 1

	End Method

	
	Method UpdateVertex(vx:Int, x:Float, y:Float, z:Float)
	
		VertexCoords surf, v + vx, x, y, z
	
	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method Update(target:TEntity)
	
		If Alpha <= 0 Then
		
			Hide
			hidden = 1
						
		Else

			TFormVector scalex, 0, 0, target, Null
			Local X1:Float = TFormedX()
			Local Y1:Float = TFormedY()
			Local Z1:Float = TFormedZ()
	    
			TFormVector 0, scaley, 0, target, Null
			Local X2:Float = TFormedX()
			Local Y2:Float = TFormedY()
			Local Z2:Float = TFormedZ()
			
			' set vertices
			VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
			VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
			VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
			VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
			' set colors
			'VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha
			
			hidden = 0

		EndIf
			
	End Method

		' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method UpdateLine(target:TEntity)
	
		TFormVector scalex, 0, 0, target, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
	    
		TFormVector 0, scaley, 0, target, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
			
		' set vertices
		VertexCoords surf, v + 0, x - X1 - X2, y - Y1 - Y2, z - Z1 - Z2
		VertexCoords surf, v + 1, x - X1 + X2, y - Y1 + Y2, z - Z1 + Z2
		VertexCoords surf, v + 2, x + X1 + X2, y + Y1 + Y2, z + Z1 + Z2
		VertexCoords surf, v + 3, x + X1 - X2, y + Y1 - Y2, z + Z1 - Z2
				
	End Method
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha1 * a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha2 * a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha3 * a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha4 * a
			
	End Method

	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAllAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], a
			
	End Method
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateVertexColors(r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, r, g, b, a * Alpha
		VertexColor surf, v + 1, r, g, b, a * Alpha
		VertexColor surf, v + 2, r, g, b, a * Alpha
		VertexColor surf, v + 3, r, g, b, a * Alpha
			
	End Method
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateScale()
	
		PositionEntity temp, x, y, z
		RotateEntity temp, pitch, yaw, roll
	
		TFormVector scalex, 0, 0, temp, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
    
		TFormVector 0, scaley, 0, temp, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
		
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
			
	End Method
		
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method UpdateRotation(target:TEntity)
	
		Local PIVOT:TPivot = CreatePivot()
	
		If (Alpha1 + Alpha2 + Alpha3 + Alpha4) <= 0 Then
			
			Hide
			
		Else
					
			PositionEntity PIVOT, x, y, z
	
			PointEntity PIVOT, target
			RotateEntity PIVOT, EntityPitch(target), EntityYaw(target), rotation
			
			TFormVector scalex, 0, 0, PIVOT, Null
			Local X1:Float = TFormedX()
			Local Y1:Float = TFormedY()
			Local Z1:Float = TFormedZ()
	    
			TFormVector 0, scaley, 0, PIVOT, Null
			Local X2:Float = TFormedX()
			Local Y2:Float = TFormedY()
			Local Z2:Float = TFormedZ()
			
			' set vertices
			VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
			VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
			VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
			VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
			' set colors
			VertexColor surf, v + 0, RGB1[0], RGB1[1], RGB1[2], Alpha1
			VertexColor surf, v + 1, RGB2[0], RGB2[1], RGB2[2], Alpha2
			VertexColor surf, v + 2, RGB3[0], RGB3[1], RGB3[2], Alpha3
			VertexColor surf, v + 3, RGB4[0], RGB4[1], RGB4[2], Alpha4
			
		End If
		
		FreeEntity PIVOT

	End Method

	Method AlignToTarget(x:Float, y:Float, z:Float, angle:Float = 0.0)
	
		Local PIVOT:TPivot = CreatePivot()
	
		PositionEntity PIVOT, x, y, z
					
		Local yaw:Float,pitch:Float,roll:Float
		Local x1:Float,y1:Float,z1:Float
		Local x2:Float,y2:Float,z2:Float
		Local x3:Float,y3:Float,z3:Float
		
		yaw=-ATan2(x,z)
		
		x1=z*Sin(yaw)+x*Cos(yaw)
		y1=y	
		z1=z*Cos(yaw)-x*Sin(yaw)
		
		pitch=-ATan2(y1,z1)
	
		x2=x1
		y2=y1*Cos(pitch)-z1*Sin(pitch)
		z2=y1*Sin(pitch)+z1*Cos(pitch)
		
		roll= -ATan2(x2, y2)
	
		x3=x2*Cos(roll)-y2*Sin(roll)
		y3=x2*Sin(roll)+y2*Cos(roll)
		z3=z2
	
		If y<0 Then roll:+180
		
		RotateEntity PIVOT, pitch, yaw, roll + angle

		TFormVector scalex, 0, 0, PIVOT, Null
		x1 = TFormedX()
		y1 = TFormedY()
		z1 = TFormedZ()
	    
		TFormVector 0, scaley, 0, PIVOT, Null
		x2 = TFormedX()
		y2 = TFormedY()
		z2 = TFormedZ()
			
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
		' set colors
		VertexColor surf, v + 0, RGB1[0], RGB1[1], RGB1[2], Alpha1
		VertexColor surf, v + 1, RGB2[0], RGB2[1], RGB2[2], Alpha2
		VertexColor surf, v + 2, RGB3[0], RGB3[1], RGB3[2], Alpha3
		VertexColor surf, v + 3, RGB4[0], RGB4[1], RGB4[2], Alpha4
		
		FreeEntity PIVOT
				
	End Method
	
End Type

'Simplex noise in 2D and 3D
Type TSimplex
	
	'Gradient table
	Field grad3:grad[] = [New Grad.Create(1, 1, 0), New Grad.Create(-1, 1, 0), New Grad.Create(1, -1, 0), New Grad.Create(-1, -1, 0),  ..
						 New Grad.Create(1, 0, 1), New Grad.Create(-1, 0, 1), New Grad.Create(1, 0, -1), New Grad.Create(-1, 0, -1),  ..
						 New Grad.Create(0, 1, 1), New Grad.Create(0, -1, 1), New Grad.Create(0, 1, -1), New Grad.Create(0, -1, -1)]
	
	'Permutation table.
	Field perm:Int[] = New Int[512]
	
	'Permutation table containing precomputed, mod12'd perm table.
	Field permMod12:Int[] = New Int[512]
	
	'Precomputed skew factors.
	Field F2:Float = 0.5 * (Sqr(3.0) - 1.0)
	Field G2:Float = (3.0 - Sqr(3.0)) / 6.0
	Field F3:Float = 1.0 / 3.0
	Field G3:Float = 1.0 / 6.0
  	
	Method New()
	
		'Randomize the permutation tables.
		For Local I:Int = 0 To 511
		
			perm[I] = Rand (0, 255)
			permMod12[I] = perm[I] Mod 12
			
		Next
		
	End Method
	
	'Re-Randomize the permutation tables.
	Method Randomize()
	
		For Local I:Int = 0 To 511
		
			perm[I] = Rand (0, 255)
			permMod12[I] = perm[I] Mod 12
			
		Next
		
	End Method
	
	'Should be faster than Floor()
	Method FastFloor:Int(x:Float)
	
		Local y:Int
	
		If x > 0
			y = Int (x)
		Else
			y = Int (x - 1)
		End If
		
		Return y
		
	End Method
	
	'Dot product for 3D Noise
	Method Dot3D:Float (g:Grad, x:Float, y:Float, z:Float)
	
		Return g.x * x + g.y * y + g.z * z
	
	EndMethod
	
	'Dot product for 2D Noise
	Method Dot2D:Float (g:Grad, x:Float, y:Float)
	
		Return g.x * x + g.y * y
	
	EndMethod
	
  	' 2D simplex noise
  	Method Noise_2D:Float (xin:Float, yin:Float)
		
		' Noise contributions from the three corners
	    Local n0:Float, n1:Float, n2:Float
		
	    ' Skew the input space to determine which simplex cell we're in
		Local s:Float = (xin + yin) * F2 ' Hairy factor for 2D
		
	    Local I:Int = FastFloor(xin + s)
	    Local j:Int = FastFloor(yin + s)
		
	    Local t:Float = (I + j) * G2
		
		' Unskew the cell origin back to (x,y) space
	    Local X0:Float = I - t
	    Local Y0:Float = j - t
		
		' The x,y distances from the cell origin
	    X0 = xin - X0
	    Y0 = yin - Y0
		
	    'For the 2D case, the simplex shape is an equilateral triangle.
	    'Determine which simplex we are in.
		
		'Offsets for second (middle) corner of simplex in (i,j) coords
	    Local i1:Int, j1:Int
		
	    If X0 > Y0 Then
		
			' lower triangle, XY order: (0,0)->(1,0)->(1,1)
	    	i1 = 1
			j1 = 0
			
	    Else
		
			' upper triangle, YX order: (0,0)->(0,1)->(1,1)
			i1 = 0
			j1 = 1
			
		EndIf
		
	    ' A step of (1,0) in (i,j) means a step of (1-c,-c) in (x,y), and
	    ' a step of (0,1) in (i,j) means a step of (-c,1-c) in (x,y), where
	    ' c = (3-sqrt(3))/6
		
		' Offsets for middle corner in (x,y) unskewed coords
	    Local x1:Float = x0 - i1 + G2
	    Local y1:Float = y0 - j1 + G2
		
		' Offsets for last corner in (x,y) unskewed coords
	    Local x2:Float = x0 - 1.0 + 2.0 * G2
	    Local y2:Float = y0 - 1.0 + 2.0 * G2
		
	    ' Work out the hashed gradient indices of the three simplex corners
	    Local ii:Int = I & 255
	    Local jj:Int = j & 255
	    Local gi0:Int = permMod12[ii + perm[jj]]
	    Local gi1:Int = permMod12[ii + i1 + perm[jj + j1]]
	    Local gi2:Int = permMod12[ii + 1 + perm[jj + 1]]
		
	    ' Calculate the contribution from the three corners
	    Local t0:Float = 0.5 - X0 * X0 - Y0 * Y0
		
	    If t0 < 0 Then
		
			n0 = 0.0
			
	    Else
		
	    	t0 = t0 * t0
	    	n0 = t0 * t0 * Dot2D(grad3[gi0], X0, Y0) ' (x,y) of grad3 used for 2D gradient
			
	    EndIf
		
	    Local t1:Float = 0.5 - x1 * x1 - y1 * y1
		
	    If t1 < 0 Then
		
			n1 = 0.0
			
	    Else
		
			t1 = t1 * t1
	    	n1 = t1 * t1 * Dot2D(grad3[gi1], x1, y1)
			
	    EndIf
		
	    Local t2:Float = 0.5 - x2 * x2 - y2 * y2
		
	    If t2 < 0 Then
		
			n2 = 0.0
			
	    Else
		
	    	t2 = t2 * t2
	    	n2 = t2 * t2 * Dot2D(grad3[gi2], x2, y2)
			
	    EndIf
		
	    ' Add contributions from each corner to get the final noise value.
	    ' The result is scaled to return values in the interval [-1,1].
	    Return 70.0 * (n0 + n1 + n2)
		
  	EndMethod
	
	' 3D simplex noise
	Method Noise_3D:Float(xin:Float, yin:Float, zin:Float)
	    
		' Noise contributions from the four corners
		Local n0:Float, n1:Float, n2:Float, n3:Float
	    
		' Skew the input space to determine which simplex cell we're in
	    Local s:Float = (xin + yin + zin) * F3 ' Very nice And simple skew factor For 3D
	    Local I:Int = fastfloor(xin + s)
	    Local j:Int = fastfloor(yin + s)
	    Local k:Int = fastfloor(zin + s)
		
	    Local t:Float = (I + j + k) * G3
		
		' Unskew the cell origin back to (x,y,z) space
	    Local X0:Float = I - t
	    Local Y0:Float = j - t
	    Local Z0:Float = k - t
		
		' The x,y,z distances from the cell origin
	    X0 = xin - X0
	    Y0 = yin - Y0
	    Z0 = zin - Z0
		
	    ' For the 3D case, the simplex shape is a slightly irregular tetrahedron.
	    ' Determine which simplex we are in.
		
		' Offsets for second corner of simplex in (i,j,k) coords
	    Local i1:Int, j1:Int, k1:Int
		
		' Offsets for third corner of simplex in (i,j,k) coords
	    Local i2:Int, j2:Int, k2:Int
		
	    If X0 >= Y0 Then
		
	    	If Y0 >= Z0 Then
			
	        	i1 = 1; j1 = 0; k1 = 0; i2 = 1; j2 = 1; k2 = 0 ' X Y Z order
				
	        Else If X0 >= Z0
			
				i1 = 1; j1 = 0; k1 = 0; i2 = 1; j2 = 0; k2 = 1 ' X Z Y order
				
	        Else
			
				i1 = 0; j1 = 0; k1 = 1; i2 = 1; j2 = 0; k2 = 1 ' Z X Y order
				
	    	EndIf
			
	    Else ' x0<y0
		
	    	If Y0 < Z0
			
		  		i1 = 0; j1 = 0; k1 = 1; i2 = 0; j2 = 1; k2 = 1 ' Z Y X order
				
		  	Else If X0 < Z0
			
				i1 = 0; j1 = 1; k1 = 0; i2 = 0; j2 = 1; k2 = 1 ' Y Z X order
				
	      	Else
			
				i1 = 0; j1 = 1; k1 = 0; i2 = 1; j2 = 1; k2 = 0 ' Y X Z order
				
			EndIf
			
	    EndIf
		
	    ' A step of (1,0,0) in (i,j,k) means a step of (1-c,-c,-c) in (x,y,z),
	    ' a step of (0,1,0) in (i,j,k) means a step of (-c,1-c,-c) in (x,y,z), and
	    ' a step of (0,0,1) in (i,j,k) means a step of (-c,-c,1-c) in (x,y,z), where
	    ' c = 1/6.
		
		' Offsets for second corner in (x,y,z) coords
	    Local x1:Float = X0 - i1 + G3
	    Local y1:Float = Y0 - j1 + G3
	    Local z1:Float = Z0 - k1 + G3
		
		' Offsets for third corner in (x,y,z) coords
	    Local x2:Float = X0 - i2 + 2.0 * G3
	    Local y2:Float = Y0 - j2 + 2.0 * G3
	    Local z2:Float = Z0 - k2 + 2.0 * G3
		
		' Offsets for last corner in (x,y,z) coords
	    Local x3:Float = X0 - 1.0 + 3.0 * G3
	    Local y3:Float = Y0 - 1.0 + 3.0 * G3
	    Local z3:Float = Z0 - 1.0 + 3.0 * G3
		
	    ' Work out the hashed gradient indices of the four simplex corners
	    Local ii:Int = I & 255
	    Local jj:Int = j & 255
	    Local kk:Int = k & 255
	    Local gi0:Int = permMod12[ii + perm[jj + perm[kk]] ]
	    Local gi1:Int = permMod12[ii + i1 + perm[jj + j1 + perm[kk + k1]] ]
	    Local gi2:Int = permMod12[ii + i2 + perm[jj + j2 + perm[kk + k2]] ]
	    Local gi3:Int = permMod12[ii + 1 + perm[jj + 1 + perm[kk + 1]] ]
		
	    ' Calculate the contribution from the four corners
		
	    Local t0:Float = 0.6 - x0 * x0 - y0 * y0 - z0 * z0
		
	    If t0 < 0
		
			n0 = 0.0
			
		Else
		
	      t0 = t0 * t0
	      n0 = t0 * t0 * Dot3D (grad3[gi0], X0, Y0, Z0)
		  
	    EndIf
		
	    Local t1:Float = 0.6 - x1 * x1 - y1 * y1 - z1 * z1
		
	    If t1 < 0
		
			n1 = 0.0
			
	    Else
		
	      t1 = t1 * t1
	      n1 = t1 * t1 * Dot3D(grad3[gi1], x1, y1, z1)
		  
	    EndIf
		
	    Local t2:Float = 0.6 - x2 * x2 - y2 * y2 - z2 * z2
		
	    If t2 < 0
		
			n2 = 0.0
			
	    Else
		
	      t2 = t2 * t2
	      n2 = t2 * t2 * Dot3D(grad3[gi2], x2, y2, z2)
		  
	    EndIf
		
	    Local t3:Float = 0.6 - x3 * x3 - y3 * y3 - z3 * z3
		
	    If t3 < 0
		
			n3 = 0.0
			
	    Else
		
	      t3 = t3 * t3
	      n3 = t3 * t3 * Dot3D(grad3[gi3], x3, y3, z3)
		  
	    EndIf
		
	    ' Add contributions from each corner to get the final noise value.
	    ' The result is scaled to stay just inside [-1,1]
	    Return 32.0 * (n0 + n1 + n2 + n3)
		
	EndMethod

EndType

'Custom data type for simplex noise gradient definition.
Type Grad

	Field x:Float, y:Float, z:Float
	
	Method Create:grad(x:Float, y:Float, z:Float = 0.0)
	
		Self.x = x
		Self.y = y
		Self.z = z
		
		Return Self
	
	End Method

EndType