' TriangleNX:Float(s:TSurface, t:Int)
' TriangleNY:Float(s:TSurface, t:Int)
' TriangleNZ:Float(s:TSurface, t:Int)
' CalcNormal:Int(bank:TBank,width:Int,height:Int,x:Int,y:Int,normalsfactor:Float=1.0,inverse:Int=False)
' CalcNormals(ThisMesh:TMesh)



' --------------------------------------------------------------------------------
' Calculates the NX Value of a Trignale
' --------------------------------------------------------------------------------
Function TriangleNX:Float(s:TSurface, t:Int)

	Local v0:Int
	Local v1:Int
	Local v2:Int
	
	Local ax:Float
	Local ay:Float
	Local az:Float

	Local bx:Float
	Local by:Float
	Local bz:Float

	v0 = TriangleVertex(s, t, 0)
	v1 = TriangleVertex(s, t, 1)
	v2 = TriangleVertex(s, t, 2)
	
	ax = VertexX(s, v1) - VertexX(s, v0)
	ay = VertexY(s, v1) - VertexY(s, v0)
	az = VertexZ(s, v1) - VertexZ(s, v0)
	
	bx = VertexX(s, v2) - VertexX(s, v1)
	by = VertexY(s, v2) - VertexY(s, v1)
	bz = VertexZ(s, v2) - VertexZ(s, v1)
	
	Return (ay * bz) - (az * by)
	
End Function



' --------------------------------------------------------------------------------
' Calculates the NY Value of a Trignale
' --------------------------------------------------------------------------------
Function TriangleNY:Float(s:TSurface, t:Int)

	Local v0:Int
	Local v1:Int
	Local v2:Int
	
	Local ax:Float
	Local ay:Float
	Local az:Float

	Local bx:Float
	Local by:Float
	Local bz:Float

	v0 = TriangleVertex(s, t, 0)
	v1 = TriangleVertex(s, t, 1)
	v2 = TriangleVertex(s, t, 2)
	
	ax = VertexX(s, v1) - VertexX(s, v0)
	ay = VertexY(s, v1) - VertexY(s, v0)
	az = VertexZ(s, v1) - VertexZ(s, v0)
	
	bx = VertexX(s, v2) - VertexX(s, v1)
	by = VertexY(s, v2) - VertexY(s, v1)
	bz = VertexZ(s, v2) - VertexZ(s, v1)
	
	Return (az * bx) - (ax * bz)
	
End Function



' --------------------------------------------------------------------------------
' Calculates the NZ Value of a Trignale
' --------------------------------------------------------------------------------
Function TriangleNZ:Float(s:TSurface, t:Int)

	Local v0:Int
	Local v1:Int
	Local v2:Int
	
	Local ax:Float
	Local ay:Float
	Local az:Float

	Local bx:Float
	Local by:Float
	Local bz:Float

	v0 = TriangleVertex(s, t, 0)
	v1 = TriangleVertex(s, t, 1)
	v2 = TriangleVertex(s, t, 2)
	
	ax = VertexX(s, v1) - VertexX(s, v0)
	ay = VertexY(s, v1) - VertexY(s, v0)
	az = VertexZ(s, v1) - VertexZ(s, v0)
	
	bx = VertexX(s, v2) - VertexX(s, v1)
	by = VertexY(s, v2) - VertexY(s, v1)
	bz = VertexZ(s, v2) - VertexZ(s, v1)
	
	Return (ax * by) - (ay * bx)
	
End Function



' ----------------------------------------------------------------------------
' Calc Normal of a 2D point
' ----------------------------------------------------------------------------
Function CalcNormal:Int(bank:TBank, width:Int, Height:Int, x:Int, y:Int, normalsfactor:Float = 1.0, Inverse:Int = False)
	
	Local xm1:Int, xp1:Int, ym1:Int, yp1:Int
	Local tl:Int, tm:Int, tr:Int, ml:Int, mr:Int, bl:Int, bm:Int, br:Int
	Local vx:Float, vy:Float, vz:Float
	Local isq2:Float, sum:Float
	Local al:Float, ar:Float, at:Float, ab:Float
	Local m:Float
	Local r:Int, g:Int, b:Int
	
	If x > 0 Then xm1 = x - 1 Else xm1 = 0
	If x < width - 1 Then xp1 = x + 1 Else xp1 = width - 1
	If y > 0 Then ym1 = y - 1 Else ym1 = 0
	If y < Height - 1 Then yp1 = y + 1 Else yp1 = Height - 1
	
	tl = GetBankPixel(bank, xm1, ym1, width)
	tm = GetBankPixel(bank, x, ym1, width)
	tr = GetBankPixel(bank, xp1, ym1, width)
	ml = GetBankPixel(bank, xm1, y, width)
	mr = GetBankPixel(bank, xp1, y, width)
	bl = GetBankPixel(bank, xm1, yp1, width)
	bm = GetBankPixel(bank, x, yp1, width)
	br = GetBankPixel(bank, xp1, yp1, width)
	
	vx = 0.0
	vy = 0.0
	vz = 1.0
	
	isq2 = 1.0 / Sqr(2.0)
	sum = 1.0 + isq2 + isq2
	
	al = (tl * isq2 + ml + bl * isq2) / sum
	ar = (tr * isq2 + mr + br * isq2) / sum
	at = (tl * isq2 + tm + tr * isq2) / sum
	ab = (bl * isq2 + bm + br * isq2) / sum
	
	vx = (al - ar) / (255.0)
	vy = (at - ab) / (255.0)
		
	m = Max(0, vx * vx + vy * vy)
	m = Min(m, 1.0)
		
	vz = Sqr(1.0 - m)
		
	If normalsfactor <> 0.0
		vz = vz / normalsfactor
		m = Sqr(vx * vx + vy * vy + vz * vz)
		vx = vx / m
		vy = vy / m
		vz = vz / m
	EndIf

	If Inverse Then

		r = ((1.0 - vx) * 127.5)
		g = ((1.0 - vy) * 127.5)
		b = 255 - ((1.0 - vz) * 127.5)

	Else

		r = 255 - ((1.0 - vx) * 127.5)
		g = ((1.0 - vy) * 127.5)
		b = 255 - ((1.0 - vz) * 127.5)

	EndIf
	
	Return b | (g Shl 8) | (r Shl 16)
	
End Function