' ------------------------------------------------------------------------------------------------
' Load MEDIA
' ------------------------------------------------------------------------------------------------
Function LoadMedia()

	' --------------------------------------------------------------------------------------------
	' Load Textures
	' --------------------------------------------------------------------------------------------
	TIME.Start()
	
	MEDIA.Init(CAMERA.CAM)
			
	' Loader
	MEDIA.Load("T", "LOADER_TEXT", "loader/loader_text.tga", 1 + 8, False)
	MEDIA.Load("T", "LOADER_SPIRAL", "loader/loader_spiral.tga", 2 + 8 + 16 + 32, False)
	MEDIA.Loader_Text_Texture = MEDIA.GetTexture("LOADER_TEXT")
	MEDIA.Loader_Spiral_Texture = MEDIA.GetTexture("LOADER_SPIRAL")
	MEDIA.Update
	
	MEDIA.Load("T", "GALAXY", "galaxy.tga", 1 +8+ 16 + 32)
	MEDIA.Load("T", "RASTER1", "raster1.tga", 1 + 2 + 8)
	MEDIA.Load("T", "RASTER2", "raster2.tga", 1 + 2 + 8)
	MEDIA.Load("T", "RASTER3", "raster3.tga", 1 + 2 + 8)
	MEDIA.Load("T", "RASTER4", "raster4.tga", 1 + 2 + 8)
	
	MEDIA.Load("T", "STAR", "star.png", 1 + 2 + 8)
	MEDIA.Load("T", "DOT", "star.png", 1 + 2 + 8)
	MEDIA.Load("T", "DETAIL", "star.png", 1 + 2 + 8)
	MEDIA.Load("T", "NEBULA", "nebula2.tga", 1 + 2 + 8)
	MEDIA.Load("T", "DUST", "dust2.tga", 1 + 2 + 8)
	
	MEDIA.Load("F", "EURO", "Eurocaps/EUROCAPS.otf", 16)
	
	
	rem
	
	' No Texture
	MEDIA.Load("T", "NOTEX", "notex.tga", 1)
	
	' Milkyway Textures
	MEDIA.Load("T", "MILKYWAY_STRIP", "milkyway/milkyway_panorama.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "MILKYWAY_DETAIL", "milkyway/milkyway_detail.tga", 1 + 8)
	MEDIA.Load("T", "MILKYWAY_STARS", "milkyway/milkyway_stars.tga", 1 + 8)
	MEDIA.Load("T", "MILKYWAY_STAR", "milkyway/milkyway_star.tga", 2 + 8)
	
	' Star Textures
	MEDIA.Load("T", "STARATMO", "star/staratmo.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "STARFLARE", "star/starflare.tga", 1 + 8)
	MEDIA.Load("T", "STARGLOW1", "star/starglow1.tga", 1 + 8 + 16 + 32)
	MEDIA.Load("T", "STARGLOW2", "star/starglow2.tga", 1 + 8 + 16 + 32)
	MEDIA.Load("T", "STARGLOW3", "star/starhotspot.tga", 1 + 2 + 8 + 16 + 32)
	
	' Star: White Dwarf
	MEDIA.Load("T", "STARGLOW4", "star/whitedwarf_glow.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "JETA", "star/whitedwarf_jetcolor.tga", 1 + 2)
	MEDIA.Load("T", "JETB", "star/whitedwarf_jetcolor.tga", 1 + 2)
	MEDIA.Load("T", "JETC", "star/whitedwarf_disk.tga", 1 + 2)
	MEDIA.Load("T", "JETALPHA", "star/whitedwarf_jetalpha.tga", 1 + 2)
	
	' Zones Textures
	MEDIA.Load("T", "GRADHALF", "zones/gradhalf.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "GRADFULL", "zones/gradfull.tga", 1 + 2 + 8 + 16 + 32)
	
	' Planet Textures
	MEDIA.Load("T", "PLANET", "planet/planet.jpg", 1 + 8 + 16 + 32)
	MEDIA.Load("T", "PLANETGLOW", "planet/glow.tga", 1 + 2 + 8 + 16 + 32)
	
	' Icons
	MEDIA.Load("T", "RADIOACTIVITY", "icons/radioactive.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "GRAVITATION", "icons/gravitation.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "TEMPERATURE", "icons/temperature.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "ORBIT", "icons/orbit.tga", 1 + 2 + 8 + 16 + 32)
	MEDIA.Load("T", "JET", "icons/jet.tga", 1 + 2 + 8 + 16 + 32)
				
	' --------------------------------------------------------------------------------------------
	' Load Fonts
	' --------------------------------------------------------------------------------------------	
	MEDIA.Load("F", "MICRO", "Acorn/Acorn Nostalgia.otf", 64 * Scaler)
	MEDIA.Load("F", "SMALL", "Acorn/Acorn Nostalgia.otf", 128 * Scaler)
	MEDIA.Load("F", "LARGE", "Anita/Anita semi square.otf", 768 * Scaler)
	MEDIA.Load("F", "SYSTEM", "Steelfish/Steelfish rg.otf", 256 * Scaler)
	MEDIA.Load("F", "FPS", "Frapsy/Frapsy.otf", 56 * Scaler)

	' --------------------------------------------------------------------------------------------
	' Load Sounds
	' --------------------------------------------------------------------------------------------	
	MEDIA.Load("S", "BLIP", "blip01.ogg")
	MEDIA.Load("S", "AMBIENT", "ambient.ogg", SOUND_LOOP)
	MEDIA.Load("S", "ENGINEA", "engine1.ogg", SOUND_LOOP)
	MEDIA.Load("S", "ENGINEB", "engine2.ogg", SOUND_LOOP)
	MEDIA.Load("S", "RADIATION", "radiation.ogg", SOUND_LOOP)
	MEDIA.Load("S", "JETHIT", "jethit.ogg")
	
	' --------------------------------------------------------------------------------------------
	' Create Textures
	' --------------------------------------------------------------------------------------------	
	MEDIA.Create("T", "STARDETAIL1", STAR_DETAILTEXSIZE, STAR_DETAILTEXSIZE)
	MEDIA.Create("T", "STARDETAIL2", STAR_DETAILTEXSIZE, STAR_DETAILTEXSIZE)
	MEDIA.Create("T", "STARDETAIL3", STAR_DETAILTEXSIZE, STAR_DETAILTEXSIZE)
	MEDIA.Create("T", "CUBEPIX0", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	MEDIA.Create("T", "CUBEPIX1", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	MEDIA.Create("T", "CUBEPIX2", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	MEDIA.Create("T", "CUBEPIX3", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	MEDIA.Create("T", "CUBEPIX4", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	MEDIA.Create("T", "CUBEPIX5", STAR_CUBETEXSIZE, STAR_CUBETEXSIZE, 16 + 32)
	
	endrem
				
	TIME.Stop(LOCALE.Get("LOG_MEDIALOADED"))

End Function