' ------------------------------------------------------------------------------------------------
' Project
' ------------------------------------------------------------------------------------------------
Const PROJECT_TITLE:String = "Framework"

' ------------------------------------------------------------------------------------------------
' Additional Key Codes
' ------------------------------------------------------------------------------------------------
Const KEY_CFLEX:Int = 220


' ------------------------------------------------------------------------------------------------
' Texture QUality
' ------------------------------------------------------------------------------------------------
Global GAME_QUALITY:String = "LQ"

' ------------------------------------------------------------------------------------------------
' Paths
' ------------------------------------------------------------------------------------------------
Global PATH_Font:String = "font/"							' Path: Font
Global PATH_Models:String = "models/"						' Path: Models
Global PATH_Texture:String = "textures/"+GAME_QUALITY+"/"	' Path: Texture
Global PATH_Sound:String = "sound/"							' Path: Sound
Global PATH_Screenshot:String = "screenshot/"				' Path: Screenshots
Global PATH_Locale:String = "locale/"						' Path: Locale

' ------------------------------------------------------------------------------------------------
' Game Global Values
' ------------------------------------------------------------------------------------------------
Global GAME_SIZE:Int = 1000									' Game: Size of Starfield
Global GAME_LOD:Int = 512									' Game: Map Level of Detail
Global GAME_SEED:Int = 43									' Game: Initial Seed
Global GAME_VERSION:Float = 1.000							' Game: Version
Global GAME_SPEED:Float = 0.0001								' Game: Speed Multiplicator
Global GAME_HOMEKEEPINGSCALE:Int = 10000					' Game: Homekeeping Sandbox Scale
Global GAME_LANGUAGE:String = "EN"							' Game: Language for Localization


' ------------------------------------------------------------------------------------------------
' Screen Globals
' ------------------------------------------------------------------------------------------------
Global SCREEN_WIDTH:Int = 1920								' Graphics: Screen Width
Global SCREEN_HEIGHT:Int = 1080	 							' Graphics: Screen Height
Global SCREEN_DEPTH:Int = 32								' Graphics: Screen Depth
Global SCREEN_MODE:Int = 2									' Graphics: Screen Mode
Global SCREEN_RATE:Int = 1000									' Graphics: Screen Refresh Rate
Global SCREEN_DESKTOPWIDTH:Int = DesktopWidth()				' Graphics: Desktop Center horizontal
Global SCREEN_DESKTOPHEIGHT:Int = DesktopHeight()			' Graphics: Desktop Center vertical
Global SCREEN_CENTERX:Int = SCREEN_DESKTOPWIDTH / 2			' Graphics: Desktop Center horizontal
Global SCREEN_CENTERY:Int = SCREEN_DESKTOPHEIGHT / 2		' Graphics: Desktop Center vertical
Global SCREEN_TIMER:TTimer = CreateTimer(1000)				' Graphics: Maximum Refresh Rate
Global CANVAS_TIMER:TTimer = CreateTimer(SCREEN_RATE)				' Graphics: Maximum Refresh Rate
Global Scaler:Float											' Graphics: Global Screen Scale Factor
Global SCREEN_ASPECT:Float = SCREEN_WIDTH * 1.0 / SCREEN_HEIGHT

' ------------------------------------------------------------------------------------------------
' Localization
' ------------------------------------------------------------------------------------------------
Global LOCALE:TLocale = New TLocale

' ------------------------------------------------------------------------------------------------
' Noise
' ------------------------------------------------------------------------------------------------
'Global NOISE:TSimplex = New TSimplex

' ------------------------------------------------------------------------------------------------
' Gradient
' ------------------------------------------------------------------------------------------------
'Global GRADIENT:TGradient' = New TGradient

' ------------------------------------------------------------------------------------------------
' Logging
' ------------------------------------------------------------------------------------------------
Global INI_LogToFile:Int = True
Global INI_LogToConsole:Int = True

' ------------------------------------------------------------------------------------------------
' MaxGUI
' ------------------------------------------------------------------------------------------------
Global MAXGUI_WINDOW:TGadget								' MAXGUI: Main Window
Global MAXGUI_CANVAS:TGadget								' MaxGUI: Canvas


' ------------------------------------------------------------------------------------------------
' Types
' ------------------------------------------------------------------------------------------------
Global FLAG:TFlag = New TFlag								' Flag Management
Global FPS:TFPS = New TFPS									' FPS Counter
'Global info:TInfo = New TInfo								' Information Text
Global MEDIA:TMedia = New TMedia							' Media Management
Global TIME:TTime = New TTime								' Time measurement
'Global MILKYWAY:TMilkyway = New TMilkyway					' Milkyway Background

' ------------------------------------------------------------------------------------------------
' Timed VSYNC
' ------------------------------------------------------------------------------------------------
Global TIMER_Safe:Int = SCREEN_RATE							' Safe FPS limit
Global TIMER_Update:Int = 0									' Update Frequency
Global TIMER_Interval:Int = 0								' Update Interval Helper
Global TIMER_Timer:Int = MilliSecs()						' Current Timer
Global TIMER_Lasttimer:Int = MilliSecs()					' Last Timer

' ------------------------------------------------------------------------------------------------
' Arrays
' ------------------------------------------------------------------------------------------------
Global Switch:String[] = ["off", "on"]						' simple on/off Array

' ------------------------------------------------------------------------------------------------
' Input
' ------------------------------------------------------------------------------------------------
Global MouseWheel:Int = 1
Global MouseButton:Int

' ------------------------------------------------------------------------------------------------
' World
' ------------------------------------------------------------------------------------------------
Global WORLD_MODE:Int = 1
Global WORLD_MODES:String[] = ["Interstellar", "Stellar", "Planetar"]

' ------------------------------------------------------------------------------------------------
' Moving
' ------------------------------------------------------------------------------------------------
Global PLAYER_MAXSPEED:Float = 100.0
Global PLAYER_SPEEDMULTIPLICATOR:Float = 10.0
Global PLAYER_MASSBRAKE:Float
Global PLAYER_AUTOBRAKE:Float
Global PlayerZSpeed:Int
Global PlayerYSpeed:Int
Global PlayerXSpeed:Int
Global PlayerVXSpeed:Int
Global PlayerBrake:Int
Global PlayerTurbo:Int
Global PLAYER_ALIGN_NEAREST:Int
Global PLAYER_ALIGN_NEXT:Int

' ------------------------------------------------------------------------------------------------
' Master Pivots
' ------------------------------------------------------------------------------------------------
Global PIVOT_MASTER:TPivot = CreatePivot()
Global PIVOT_CAMERA:TPivot = CreatePivot()


' ------------------------------------------------------------------------------------------------
' Test
' ------------------------------------------------------------------------------------------------
Global TITLE_BLIP:TBeat
Global TITLE_FADE:TBeat

Global TITLE_TIMER:Int
Global TITLE_DIGITS:Int
Global TITLE_TEXT:String
Global TITLE_OUTPUT:String
Global TITLE_CHANNEL:TChannel = New TChannel
Global MUSIC_CHANNEL:TChannel = New TChannel
Global TITLE_ALPHA:Float

Global CHANNEL_AMBIENT:TChannel
Global CHANNEL_ENGINE1:TChannel
Global CHANNEL_ENGINE2:TChannel
Global CHANNEL_JET:TChannel
Global CHANNEL_RADIATION:TChannel

Global STAR_DETAILTEXSIZE:Int = 64
Global STAR_JETTEXSIZE:Int = 64
Global STAR_CUBETEXSIZE:Int = 256

Global WHITEDWARF_MODES:String[] = ["White Dwarf", "Pulsar", "Neutron Star", "Magnetar"]