Type TCam

	Field cam:TCamera										' camera entity
	Field parent:TEntity									' camera parent

	Field X:Float = 0.0										' Position X
	Field Y:Float = 0.0										' Position Y
	Field Z:Float = 0.0										' Position Z

	Field OX:Float = 0.0									' Old Position X
	Field OY:Float = 0.0									' Old Position Y
	Field OZ:Float = 0.0									' Old Position Z

	Field OPitch:Float = 0.0								' Old Pitch
	Field OYaw:Float = 0.0									' Old Yaw
	Field ORoll:Float = 0.0									' Old Roll
	
	Field Pitch:Float = 0.0									' Pitch
	Field Yaw:Float = 0.0									' Yaw
	Field Roll:Float = 0.0									' Roll
	
	Field roller:Float
	
	Field CLScolor:Int[] = [0, 0, 0]						' Background color
	Field FOGcolor:Int[] = [0, 0, 0]						' Fog color
		
	Field FieldofView:Float = 90.0							' Field of View
	Field FOGmode:Int = False								' Fog Mode
	Field Zoom:Float = 1.0									' Zoom factor

	Field RangeMin:Float = 1.0								' Frustum start
	Field RangeMax:Float = 10000.0							' Frustum end
	Field FOGrangeMin:Float = 1.0							' Fog Frustum start
	Field FOGrangeMax:Float = 10000.0						' Fog Frustum end
	
	Field ViewX:Int = 0										' Viewport X Position
	Field ViewY:Int = 0										' Viewport Y Position
	Field width:Int = SCREEN_WIDTH							' Viewport width
	Field Height:Int = SCREEN_HEIGHT						' Viewport height

	Field MX:Int											' Mouse X Position
	Field MY:Int											' Mouse Y Position
	
	Field PX:Int											' Projected X
	Field PY:Int											' Projected Y
	
	Const QuatToEuler:Double = 0.00001
	
	Field Speed:Float = 1.0									' Camera Movespeed
	Field RollSpeed:Float = 1.0								' Camera Rollspeed
	Field TurnSpeed:Float = 200.0							' Camera Turnspeed (Mousemove)
	Field Sensitivity:Float = 1.0							' Overall Camera Sensitivity
	
	Field CurrentSpeed:Float								' Current Z Movespeed
	Field CurrentYSpeed:Float								' Current Y Movespeed
	
	Global Xspeed:Float										' Current X-Vector Speed
	Global Yspeed:Float										' Current Y-Vector Speed
	Global Zspeed:Float										' Current Z-Vector Speed
	
	Global movespeed:Float
	Global vertspeed:Float
	Global horispeed:Float
	Global rotspeed:Float
	
	Field Glob:Int = False									' Local/Global flag


	' --------------------------------------------------------------------------------------------
	' Add new camera
	' --------------------------------------------------------------------------------------------
	Method Add()
	
		cam = CreateCamera(parent)
		
	End Method
	
	' --------------------------------------------------------------------------------------------
	' Show Camera
	' --------------------------------------------------------------------------------------------
	Method Show()
	
		ShowEntity cam
	
	End Method

	' --------------------------------------------------------------------------------------------
	' Hide Camera
	' --------------------------------------------------------------------------------------------
	Method Hide()
	
		HideEntity cam
	
	End Method
	
	' --------------------------------------------------------------------------------------------
	' Camera movement
	' --------------------------------------------------------------------------------------------
	Method MoveTest()
	
		Local tx:Float, ty:Float
		Local rolling:Float
		
		tx = LimitFloat(Normalize(mx, 0, SCREEN_WIDTH - 0.5, 1, -1), -1, 1)
		ty = LimitFloat(Normalize(MY, 0, SCREEN_HEIGHT - 0.5, -1, 1), -1, 1)
		
		xspeed = ty * TurnSpeed * FPS.multi' * ((1.0 / MouseWheel ^ 2))
		yspeed = tx * TurnSpeed * FPS.multi' * ((1.0 / MouseWheel ^ 2))
		zspeed = PlayerXSpeed * RollSpeed * FPS.multi * 0.25
		

		' rotation		
		If PlayerXSpeed = 0 Then
		
			rotspeed:*0.995
		
		Else
		
			rotspeed:+zspeed
			If Abs(rotspeed) > FPS.multi * 25 Then rotspeed = FPS.multi * 25 * Sgn(rotspeed)
		
		EndIf
		
		' horizontal speed
		If (PlayerVXSpeed = 0) Then
		
			horispeed:*0.995

		Else
		
			horispeed:+(PlayerVXSpeed * 0.005 * (1.0 + Abs(Y / 10.0)) * FPS.multi)
			If Abs(horispeed) > FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) Then horispeed = FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) * Sgn(horispeed)

		EndIf

		' vertical speed
		If (PlayerYSpeed = 0) Then
		
			vertspeed:*0.995

		Else
		
			vertspeed:+(PlayerYSpeed * 0.005 * (1.0 + Abs(Y / 10.0)) * FPS.multi)
			If Abs(vertspeed) > FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) Then vertspeed = FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) * Sgn(vertspeed)

		EndIf
		
		' forward speed
		If (PlayerZSpeed = 0) Then
		
			movespeed:*0.995
			
		Else
			
			movespeed:+(PlayerZSpeed * 0.005 * (1.0 + Abs(Y / 10.0)) * FPS.multi)
			If Abs(movespeed) > FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) Then movespeed = FPS.multi * 10 * (1.0 + Abs(Y / 10.0)) * Sgn(movespeed)
			
		EndIf
				
		' forward movement
		MoveEntity cam, horispeed, vertspeed, movespeed
		
		' vertical movement
		'MoveEntity cam, 0, vertspeed, 0
	
		Local Quat:TQuaternion = EulerToQuat(0.0, 0.0, 0.0)
		Local Turn_Quat:TQuaternion = EulerToQuat(0.0, 0.0, 0.0)
				
		'rem
		' quaternion rotation
		If Glob = False
		
			Quat = EulerToQuat(EntityPitch(cam, True), EntityYaw(cam, True), EntityRoll(cam, True))
			Turn_Quat = EulerToQuat(Xspeed, Yspeed, rotspeed)
			Quat = MultiplyQuats(Quat, Turn_Quat)
			Quat = NormalizeQuat(Quat)
						
			QuatToEuler2(Quat.x, Quat.y, Quat.z, Quat.w, Pitch, Yaw, Roll)
						
		Else
	
			Pitch:+Xspeed
			yaw:+Yspeed
			Roll:+roller
			
		EndIf

		RotateEntity cam, pitch, yaw, roll
		
		'endrem
		
		rem
		If Glob = False
		
		        Quat = EulerToQuat(EntityPitch(cam, True), EntityYaw(cam, True), EntityRoll(cam, True))
		        Turn_Quat = EulerToQuat(Xspeed, Yspeed, rotspeed)
		        Quat = MultiplyQuats(Quat, Turn_Quat)
		        Quat = NormalizeQuat(Quat)
		        QuatToEuler2(Quat.x, Quat.y, Quat.z, Quat.w, Pitch, Yaw, Roll)
		        RotateEntity cam, Pitch, Yaw, Roll
		Else
		
		        RotateEntity cam, EntityPitch(cam) + Xspeed, EntityYaw(cam) + Yspeed, EntityRoll(cam) + Zspeed
		       
		EndIf		
		
		endrem
				
	End Method


	' --------------------------------------------------------------------------------------------
	' Update Camera
	' --------------------------------------------------------------------------------------------
	Method Update()

		OX = EntityX(cam)
		OY = EntityY(cam)
		OZ = EntityZ(cam)

		OPitch = EntityPitch(cam)
		OYaw = EntityYaw(cam)
		ORoll = EntityRoll(cam)
	
		'PositionEntity cam, x, y, z
		'RotateEntity cam, pitch, yaw, roll
		CameraRange cam, rangemin, rangemax
		CameraFogRange cam, FOGrangemin, FOGrangemax
		CameraClsColor cam, CLScolor[0], CLScolor[1], CLScolor[2]
		CameraZoom cam, zoom
		CameraViewport cam, viewx, viewy, width, Height
	
	End Method
	
	' --------------------------------------------------------------------------------------------
	' Update Camera Position
	' --------------------------------------------------------------------------------------------
	Method UpdatePosition()

		PositionEntity cam, x, y, z
	
	End Method
	
	Method Moved:Int()
	
		If (ox <> x) Or (oy <> y) Or (oz <> z) Then Return True
		
		Return False
			
	End Method
	
	' --------------------------------------------------------------------------------------------
	' Calculate Screen Projection coordinates
	' --------------------------------------------------------------------------------------------
	Method Project(x:Float = 0.0, y:Float = 0.0, z:Float = 0.0)
		
		CameraProject cam, x, y, z
		PX = ProjectedX()
		PY = ProjectedY()
	
	End Method
		
	' --------------------------------------------------------------------------------------------
	' Store current camera position
	' --------------------------------------------------------------------------------------------
	Method GetCameraPosition(glob:Int = False)
	
		X = EntityX(cam, glob)
		Y = EntityY(cam, glob)
		Z = EntityZ(cam, glob)
					
	End Method

	' ----------------------------------------------------------------------------
	' help function of turncam
	' ----------------------------------------------------------------------------
	Function EulerToQuat:TQuaternion(pitch:Float, yaw:Float, roll:Float)
	
		Local cr:Float = Cos(-roll / 2.0)
		Local cp:Float = Cos(pitch / 2.0)
		Local cy:Float = Cos(yaw / 2.0)
		Local sr:Float = Sin(-roll / 2.0)
		Local sp:Float = Sin(pitch / 2.0)
		Local sy:Float = Sin(yaw / 2.0)
		Local cpcy:Float = cp * cy
		Local spsy:Float = sp * sy
		Local spcy:Float = sp * cy
		Local cpsy:Float = cp * sy
		
		Local q:TQuaternion = New TQuaternion
		
		q.w:Float = cr * cpcy + sr * spsy
		q.x:Float = sr * cpcy - cr * spsy
		q.y:Float = cr * spcy + sr * cpsy
		q.z:Float = cr * cpsy - sr * spcy
		
		Return q
		
	End Function
	
	
	' ----------------------------------------------------------------------------
	' help Function of turncam
	' ----------------------------------------------------------------------------
	Function QuatToEuler2(x:Float, y:Float, z:Float, w:Float, pitch:Float Var, yaw:Float Var, roll:Float Var)
	
		Local sint:Float = (2.0 * w * y) - (2.0 * x * z)
		Local cost_temp:Float = 1.0 - (sint * sint)
		Local cost:Float
	
		If Abs(cost_temp) > QuatToEuler
	
			cost = Sqr(cost_temp)
	
		Else
	
			cost = 0.0
	
		EndIf
	
		Local sinv:Float, cosv:Float, sinf:Float, cosf:Float
		
		If Abs(cost) > QuatToEuler
		
			sinv = ((2.0 * y * z) + (2.0 * w * x)) / cost
			cosv = (1.0 - (2.0 * x * x) - (2.0 * y * y)) / cost
			sinf = ((2.0 * x * y) + (2.0 * w * z)) / cost
			cosf = (1.0 - (2.0 * y * y) - (2.0 * z * z)) / cost
			
		Else
			
			sinv = (2.0 * w * x) - (2.0 * y * z)
			cosv = 1.0 - (2.0 * x * x) - (2.0 * z * z)
			sinf = 0.0
			cosf = 1.0
			
		EndIf
		
		pitch = ATan2(sint, cost)
		yaw = ATan2(sinf, cosf)
		roll = -ATan2(sinv, cosv)
		
	End Function
	
	
	' ----------------------------------------------------------------------------
	' help Function of turncam
	' ----------------------------------------------------------------------------
	Function MultiplyQuats:TQuaternion(q1:TQuaternion, q2:TQuaternion)
	
		Local q:TQuaternion = New TQuaternion
		
		q.w = q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z
		q.x = q1.w * q2.x + q1.x * q2.w + q1.y * q2.z - q1.z * q2.y
		q.y = q1.w * q2.y + q1.y * q2.w + q1.z * q2.x - q1.x * q2.z
		q.z = q1.w * q2.z + q1.z * q2.w + q1.x * q2.y - q1.y * q2.x
	
		Return q
	
	End Function
	
	
	' ----------------------------------------------------------------------------
	' help Function of turncam
	' ----------------------------------------------------------------------------
	Function NormalizeQuat:TQuaternion(q:TQuaternion)
	
		Local uv:Float = Sqr(q.w * q.w + q.x * q.x + q.y * q.y + q.z * q.z)
	
		q.w = q.w / uv
		q.x = q.x / uv
		q.y = q.y / uv
		q.z = q.z / uv
	
		Return q
	
	End Function

End Type