' ------------------------------------------------------------------------------------------------
' Exact FPS counter
' ------------------------------------------------------------------------------------------------

Type TFPS

	Global renders:Int = 0

	Field FPS:Int = 60										' current FPS value
	Field interval:Int = 999
	Field averagefps:Int = 60								' average FPS value
	Field framedrops:Int = 0								' dropped frames
	Field memory:Int = 0									' used memory
	Field oldlooptime:Int = 0
	Field looptime:Int = 0
	Field multi:Float										' main loop multiplicator

	Field old:Int = MilliSecs()
	Field totalfps:Int = 30
	Field Ticks:Int

	' --------------------------------------------------------------------------------------------
	' METHOD: Update FPS counter
	' --------------------------------------------------------------------------------------------
	Method Update()

		renders:+1

		looptime = MilliSecs() - oldlooptime
		oldlooptime = MilliSecs()

		If MilliSecs() - old >= interval Then

			old = MilliSecs()

			FPS = renders * (1000 / interval)
			renders = 0
			totalfps:+FPS
			Ticks:+1
			
			averagefps = totalfps / Ticks

			memory = GCMemAlloced()

		EndIf

	End Method

End Type