Type TGradient

	Field colors:Int
	Field steps:Int
	Field Inverse:Int
	Field div:Int

	Field P:Float[65536 + 1]
	Field R:Int[65536 + 1]
	Field G:Int[65536 + 1]
	Field B:Int[65536 + 1]
	
	Field GradientPercent:Float[65536 + 1]
	Field GradientRed:Int[65536 + 1]
	Field GradientGreen:Int[65536 + 1]
	Field GradientBlue:Int[65536 + 1]
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Add new Gradient
	' --------------------------------------------------------------------------------------------
	Method Generate()

		Local i:Int, pos1:Int, pos2:Int, pdiff:Int
		Local rdiff:Int, gdiff:Int, bdiff:Int
		Local rstep:Float, gstep:Float, bstep:Float
		Local counter:Int = 0
		
		Local Percent:Float, RED:Int, Green:Int, Blue:Int
		
		ReadData colors, steps, Inverse, div

		If Inverse Then
		
			For i = colors To 1 Step - 1
							
				ReadData Percent, RED, Green, Blue
			
				GradientPercent[i] = 100.0 - Percent
				GradientRed[i] = RED
				GradientGreen[i] = Green
				GradientBlue[i] = Blue

			Next
		
		Else
		
			For i = 1 To colors Step 1
			
				ReadData Percent, RED, Green, Blue
			
				GradientPercent[i] = Percent
				GradientRed[i] = RED
				GradientGreen[i] = Green
				GradientBlue[i] = Blue
			
			Next
		
		EndIf
		
		While counter < colors
		
			pos1 = GradientPercent[counter] * steps * 1.0 / 100
			pos2 = GradientPercent[counter + 1] * steps * 1.0 / 100
			
			If pos1 > Steps Then pos1 = Steps
			If pos2 > Steps Then pos2 = Steps
						
			pdiff = pos2 - pos1
			
			rdiff = GradientRed[counter] - GradientRed[counter + 1]
			gdiff = GradientGreen[counter] - GradientGreen[counter + 1]
			bdiff = GradientBlue[counter] - GradientBlue[counter + 1]
			
			rstep = rdiff * 1.0 / pdiff
			gstep = gdiff * 1.0 / pdiff
			bstep = bdiff * 1.0 / pdiff
			
			For i = 0 To pdiff
					
				R[pos1 + i] = Int(GradientRed[counter] - (rstep * i))
				g[pos1 + i] = Int(GradientGreen[counter] - (gstep * i))
				B[pos1 + i] = Int(GradientBlue[counter] - (bstep * i))
				
			Next
			
			counter = counter + 1
			
		Wend
	
	End Method


End Type