' ------------------------------------------------------------------------------------------------
' Quad Type
' ------------------------------------------------------------------------------------------------
Type TQuad

	Field id:Int
	
	Field x:Float = 0.0										' position x
	Field y:Float = 0.0										' position y
	Field z:Float = 0.0										' position z
	
	Field mx:Float = 0.0
	Field my:Float = 0.0
	Field mz:Float = 0.0
	
	Field pitch:Float = 0.0
	Field yaw:Float = 0.0
	Field roll:Float = 0.0
	
	Field row:Int = 0										' texture row
	Field col:Int = 0										' texture column
	
	Field Size:Float = 1.0									' base size
	Field Scale:Float = 1.0									' base scale
	Field scalex:Float = 1.0								' current size X
	Field scaley:Float = 1.0								' current size Y
	'Field scalez:Float = 1.0								' c
	Field scaler:Float = 1.0									' scale multiplier

	Field distance:Float = 0.0								' distance to cam
	'Field Hidden:Int = 0									' hidden flag
	'Field vanish:Float = 1.0								' vanish rate
	'Field expanding:Float = 1.0								' expand rate
	
	Field RGB:Int[] = [255, 255, 255, 255]					' star vertex color

	Field RGB1:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB2:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB3:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB4:Int[] = [255, 255, 255, 255]					' nebula vertex color

	Field Alpha:Float = 1.0									' vertex alpha
	Field Alpha1:Float = 1.0								' vertex alpha #1
	Field Alpha2:Float = 1.0								' vertex alpha #2
	Field Alpha3:Float = 1.0								' vertex alpha #3
	Field Alpha4:Float = 1.0								' vertex alpha #4

	Field v:Int = 0											' vertex counter
	Field mesh:TMesh = Null									' mesh pointer
	Field surf:TSurface = Null								' surface pointer

	Field rotation:Float									' Quad Rotation

	Field Name:String										' Quad Name
	Field cat:String = ""									' Quad Category
	
	Field check:Int											' Check Flag
	
	Field ani:Float
	Field anispeed:Float
	Field quadclass:Int = 0
	
	'Field system:TSystem
	
	'Field Animate:Float
	'Field Animate_Speed:Float
				
	'Global temp:TPivot = CreatePivot()
	Global PIVOT:TPivot = CreatePivot()
	'Global PIVOT1:TPivot = CreatePivot()
	'Global PIVOT2:TPivot = CreatePivot()


	' --------------------------------------------------------------------------------------------
	' METHOD: Add new Quad
	' --------------------------------------------------------------------------------------------
	Method Add(col:Int = 0, row:Int = 0)

		' surface setup
		If surf = Null Then surf = surf
		
		' create a new surface if vertexcount is too high
		If v + 4 > 32768 Then
		
			v = 0
			surf = CreateSurface(mesh)
			
		EndIf

		' add Vertices
		Local V0:Int = AddVertex(surf, 0, 0, 0, 1, 0)
		Local V1:Int = AddVertex(surf, 0, 0, 0, 1, 1)
		Local V2:Int = AddVertex(surf, 0, 0, 0, 0, 1)
		Local V3:Int = AddVertex(surf, 0, 0, 0, 0, 0)

		' color vertices
		VertexColor surf, V0, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, V1, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, V2, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, V3, RGB[0], RGB[1], RGB[2], Alpha

		' connect triangles
		AddTriangle surf, V0, V1, V2
		AddTriangle surf, V0, V2, V3
		
		VertexTexCoords surf, V0, col + 1, row
		VertexTexCoords surf, V1, col + 1, row + 1
		VertexTexCoords surf, V2, col, row + 1
		VertexTexCoords surf, V3, col, row

		' increase vertex counter
		If v >= 4 Then v = V0 + 4 Else v = V0

	End Method

	
	Method UpdateAnimation(row:Int, col:Int)
	
		Local v0:Int = v + 0
		Local v1:Int = v + 1
		Local v2:Int = v + 2
		Local v3:Int = v + 3
	
		VertexTexCoords surf, V0, col + 1, row
		VertexTexCoords surf, V1, col + 1, row + 1
		VertexTexCoords surf, V2, col, row + 1
		VertexTexCoords surf, V3, col, row
		
	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Hide a Quad
	' --------------------------------------------------------------------------------------------
	Method Hide()

		distance = 2 ^ 32

		' set vertices
		VertexCoords surf, v + 0, distance, distance, distance
		VertexCoords surf, v + 1, distance, distance, distance
		VertexCoords surf, v + 2, distance, distance, distance
		VertexCoords surf, v + 3, distance, distance, distance

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method Update(target:TEntity)
	
		PositionEntity PIVOT, x, y, z
	
		TFormVector ScaleX, 0, 0, target, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
    
		TFormVector 0, scaley, 0, target, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
		
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha
			
	End Method

		
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha1 * a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha2 * a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha3 * a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha4 * a
			
	End Method
	
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAllAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], a
			
	End Method
	
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateVertexColors(r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, r, g, b, a * Alpha
		VertexColor surf, v + 1, r, g, b, a * Alpha
		VertexColor surf, v + 2, r, g, b, a * Alpha
		VertexColor surf, v + 3, r, g, b, a * Alpha
			
	End Method
	
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Distance
	' --------------------------------------------------------------------------------------------
	Method UpdateDistance(target:TEntity)
	
		distance = Distance3D(x, y, z, EntityX(target, 1), EntityY(target, 1), EntityZ(target, 1))
	
	End Method
	
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateScale()
	
		PositionEntity PIVOT, x, y, z
		RotateEntity PIVOT, pitch, yaw, roll
	
		TFormVector scalex, 0, 0, PIVOT, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
    
		TFormVector 0, scaley, 0, PIVOT, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
		
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
			
	End Method

	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Align to target
	' --------------------------------------------------------------------------------------------
	Method AlignToTarget(x:Float, y:Float, z:Float, angle:Float = 0.0, dir:Int = 1)
		
		PositionEntity PIVOT, x, y, z
					
		Local yaw:Float, pitch:Float, roll:Float
		Local x1:Float, y1:Float, z1:Float
		Local x2:Float, y2:Float, z2:Float
		'Local x3:Float,y3:Float,z3:Float
		
		yaw = -ATan2(x, z)
		
		x1 = z * Sin(yaw) + x * Cos(yaw)
		y1 = y
		z1 = z * Cos(yaw) - x * Sin(yaw)
		
		pitch = -ATan2(y1, z1)
	
		x2 = x1
		y2 = y1 * Cos(pitch) - z1 * Sin(pitch)
		z2 = y1 * Sin(pitch) + z1 * Cos(pitch)
		
		roll = -ATan2(x2, y2)
		If y < 0 Then roll:+180
		
		RotateEntity PIVOT, pitch, yaw, roll + angle
		
		Select dir
		
			Case 1

					TFormVector - scalex, 0, 0, PIVOT, Null
					x1 = TFormedX()
					y1 = TFormedY()
					z1 = TFormedZ()
				    
					TFormVector 0, -scaley, 0, PIVOT, Null
					x2 = TFormedX()
					y2 = TFormedY()
					z2 = TFormedZ()

			Case 2

					TFormVector 0, -scalex, 0, PIVOT, Null
					x1 = TFormedX()
					y1 = TFormedY()
					z1 = TFormedZ()
				    
					TFormVector 0, 0, -scaley, PIVOT, Null
					x2 = TFormedX()
					y2 = TFormedY()
					z2 = TFormedZ()

			Case 3

					TFormVector 0, 0, -scalex, PIVOT, Null
					x1 = TFormedX()
					y1 = TFormedY()
					z1 = TFormedZ()
				    
					TFormVector - scaley, 0, 0, PIVOT, Null
					x2 = TFormedX()
					y2 = TFormedY()
					z2 = TFormedZ()
					
		End Select
			
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
		' set colors
		'VertexColor surf, v + 0, RGB1[0], RGB1[1], RGB1[2], Alpha1
		'VertexColor surf, v + 1, RGB2[0], RGB2[1], RGB2[2], Alpha2
		'VertexColor surf, v + 2, RGB3[0], RGB3[1], RGB3[2], Alpha3
		'VertexColor surf, v + 3, RGB4[0], RGB4[1], RGB4[2], Alpha4
		
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha

	End Method

End Type